/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.lootables.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.EitherMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.lootables.Lootables;
import me.fzzyhmstrs.lootables.data.LootablesData;
import me.fzzyhmstrs.lootables.loot.LootablePool;
import me.fzzyhmstrs.lootables.loot.LootablePoolData;
import me.fzzyhmstrs.lootables.loot.LootablePoolEntry;
import me.fzzyhmstrs.lootables.loot.LootablePoolEntryType;
import me.fzzyhmstrs.lootables.loot.LootableRarity;
import net.minecraft.class_1297;
import net.minecraft.class_181;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_8824;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0015\b\u0000\u0018\u0000 ?2\u00020\u0001:\u0001?B_\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0015\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020!2\u0006\u0010 \u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b&\u0010#J\u0015\u0010)\u001a\u00020\b2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J\u000f\u0010,\u001a\u00020+H\u0016\u00a2\u0006\u0004\b,\u0010-R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010.R\u0018\u0010/\u001a\u0004\u0018\u00010!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u00101R\u001a\u0010\u0007\u001a\u00020\u00068\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0007\u00102\u001a\u0004\b3\u00104R\u001a\u0010\t\u001a\u00020\b8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\t\u00105\u001a\u0004\b6\u00107R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010:R\u0014\u0010\u000f\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010;R\u001a\u0010\u0005\u001a\u00020\u00048\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010<\u001a\u0004\b=\u0010>R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u00101\u00a8\u0006@"}, d2={"Lme/fzzyhmstrs/lootables/loot/LootablePool;", "", "Lnet/minecraft/class_2960;", "id", "Lme/fzzyhmstrs/lootables/loot/LootableRarity;", "rarity", "Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;", "entry", "", "guaranteed", "Ljava/util/Optional;", "Lnet/minecraft/class_2561;", "description", "", "weight", "maxUses", "", "Lnet/minecraft/class_5341;", "conditions", "<init>", "(Lnet/minecraft/class_2960;Lme/fzzyhmstrs/lootables/loot/LootableRarity;Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;ZLjava/util/Optional;Ljava/util/Optional;ILjava/util/List;)V", "Lnet/minecraft/class_3222;", "player", "Lnet/minecraft/class_243;", "origin", "", "apply", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_243;)V", "Lnet/minecraft/class_47;", "context", "canApply", "(Lnet/minecraft/class_47;)Z", "playerEntity", "Lme/fzzyhmstrs/lootables/loot/LootablePoolData;", "createData", "(Lnet/minecraft/class_3222;)Lme/fzzyhmstrs/lootables/loot/LootablePoolData;", "getWeight", "()Ljava/lang/Integer;", "initData", "Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry$InvalidationType;", "type", "invalidateData", "(Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry$InvalidationType;)Z", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "data", "Lme/fzzyhmstrs/lootables/loot/LootablePoolData;", "Ljava/util/Optional;", "Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;", "getEntry$lootables", "()Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;", "Z", "getGuaranteed$lootables", "()Z", "Lnet/minecraft/class_2960;", "getId$lootables", "()Lnet/minecraft/class_2960;", "I", "Lme/fzzyhmstrs/lootables/loot/LootableRarity;", "getRarity$lootables", "()Lme/fzzyhmstrs/lootables/loot/LootableRarity;", "Companion", "lootables"})
public final class LootablePool {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_2960 id;
    @NotNull
    private final LootableRarity rarity;
    @NotNull
    private final LootablePoolEntry entry;
    private final boolean guaranteed;
    @NotNull
    private final Optional<class_2561> description;
    @NotNull
    private final Optional<Integer> weight;
    private final int maxUses;
    @NotNull
    private final List<class_5341> conditions;
    @Nullable
    private LootablePoolData data;
    @NotNull
    private static Set<class_2960> seenIds = new LinkedHashSet();
    @NotNull
    private static final MapCodec<List<class_5341>> CONDITION_CODEC;
    @NotNull
    private static final MapCodec<Optional<List<class_5341>>> OPTIONAL_CONDITION_CODEC;
    @NotNull
    private static final Function<Integer, DataResult<Integer>> checker;
    @NotNull
    private static final Codec<Integer> USES_CODEC;
    @NotNull
    private static final Codec<LootablePool> CODEC;
    @NotNull
    private static final Codec<LootablePool> REFERENCE_CODEC;
    @NotNull
    private static final MapCodec<Companion.PoolData> DATA_MAP_CODEC;
    @NotNull
    private static final Codec<Companion.PoolData> DATA_CODEC;
    @NotNull
    private static final Codec<Companion.PoolLoader> LOADER_CODEC;

    private LootablePool(class_2960 id, LootableRarity rarity, LootablePoolEntry entry, boolean guaranteed, Optional<class_2561> description, Optional<Integer> weight, int maxUses, List<? extends class_5341> conditions) {
        this.id = id;
        this.rarity = rarity;
        this.entry = entry;
        this.guaranteed = guaranteed;
        this.description = description;
        this.weight = weight;
        this.maxUses = maxUses;
        this.conditions = conditions;
    }

    /* synthetic */ LootablePool(class_2960 class_29602, LootableRarity lootableRarity, LootablePoolEntry lootablePoolEntry, boolean bl, Optional optional, Optional optional2, int n, List list, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            n = -1;
        }
        if ((n2 & 0x80) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(class_29602, lootableRarity, lootablePoolEntry, bl, optional, optional2, n, list);
    }

    @NotNull
    public final class_2960 getId$lootables() {
        return this.id;
    }

    @NotNull
    public final LootableRarity getRarity$lootables() {
        return this.rarity;
    }

    @NotNull
    public final LootablePoolEntry getEntry$lootables() {
        return this.entry;
    }

    public final boolean getGuaranteed$lootables() {
        return this.guaranteed;
    }

    public final boolean canApply(@NotNull class_47 context) {
        int totalUses;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        class_1297 class_12972 = (class_1297)context.method_296(class_181.field_1226);
        if (class_12972 == null) {
            return false;
        }
        class_1297 entity = class_12972;
        UUID uUID = entity.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        int uses = LootablesData.INSTANCE.getUses(this.id, uUID);
        if (this.maxUses > -1) {
            v2 = this.maxUses;
        } else {
            Integer n = this.entry.maxUses();
            v2 = totalUses = n != null ? n : this.maxUses;
        }
        boolean bl = 1 <= totalUses ? totalUses <= uses : false;
        if (bl) {
            return false;
        }
        for (class_5341 condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return false;
        }
        return true;
    }

    public final void apply(@NotNull class_3222 player, @NotNull class_243 origin) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        UUID uUID = player.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        LootablesData.INSTANCE.use(this.id, uUID);
        this.entry.apply(player, origin);
    }

    @Nullable
    public final Integer getWeight() {
        return this.weight.orElse(null);
    }

    private final LootablePoolData initData(class_3222 playerEntity) {
        LootablePoolData d;
        this.data = d = LootablePoolData.Companion.of(this.id, this.description.orElse(this.entry.serverDescription(playerEntity)), this.rarity, this.entry.createDisplay(playerEntity));
        return d;
    }

    public final boolean invalidateData(@NotNull LootablePoolEntry.InvalidationType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (this.entry.needsInvalidation(type)) {
            this.data = null;
            return true;
        }
        return false;
    }

    @NotNull
    public final LootablePoolData createData(@NotNull class_3222 playerEntity) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        LootablePoolData lootablePoolData = this.data;
        if (lootablePoolData == null) {
            lootablePoolData = this.initData(playerEntity);
        }
        return lootablePoolData;
    }

    @NotNull
    public String toString() {
        return Objects.toIdentityString(this) + "(id=" + this.id + ", rarity=" + this.rarity + ", entry=" + this.entry + ", guaranteed=" + this.guaranteed + ", description=" + this.description + ", weight=" + this.weight + ", maxUses=" + this.maxUses + ", conditions=" + this.conditions + ", data=" + this.data + ")";
    }

    private static final List CONDITION_CODEC$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)$tmp0.invoke(p0);
    }

    private static final Either CONDITION_CODEC$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Either)$tmp0.invoke(p0);
    }

    private static final Optional OPTIONAL_CONDITION_CODEC$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)$tmp0.invoke(p0);
    }

    private static final Either OPTIONAL_CONDITION_CODEC$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Either)$tmp0.invoke(p0);
    }

    private static final String checker$lambda$5$lambda$4(Integer $i) {
        Intrinsics.checkNotNullParameter((Object)$i, (String)"$i");
        return "Integer " + $i + " out of bounds [-1],[1,)";
    }

    private static final DataResult checker$lambda$5(Integer i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        int n = -1;
        return i == n || i > 0 ? DataResult.success((Object)i) : DataResult.error(() -> LootablePool.checker$lambda$5$lambda$4(i));
    }

    private static final class_2960 CODEC$lambda$14$lambda$6(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (class_2960)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final LootableRarity CODEC$lambda$14$lambda$7(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LootableRarity)((Object)((Function1)$tmp0).invoke((Object)p0));
    }

    private static final LootablePoolEntry CODEC$lambda$14$lambda$8(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LootablePoolEntry)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean CODEC$lambda$14$lambda$9(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional CODEC$lambda$14$lambda$10(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional CODEC$lambda$14$lambda$11(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Integer CODEC$lambda$14$lambda$12(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final List CODEC$lambda$14$lambda$13(KProperty1 $tmp0, LootablePool p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (List)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$14(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$6((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)LootableRarity.Companion.getCODEC$lootables().optionalFieldOf("rarity", (Object)LootableRarity.COMMON).forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$7((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0)), (App)LootablePoolEntry.Companion.getCODEC().fieldOf("entry").forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$8((KProperty1)Companion.CODEC.1.3.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("guaranteed", (Object)false).forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$9((KProperty1)Companion.CODEC.1.4.INSTANCE, arg_0)), (App)class_8824.field_46597.optionalFieldOf("desc").forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$10((KProperty1)Companion.CODEC.1.5.INSTANCE, arg_0)), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("weight").orElse(Optional.empty()).forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$11((KProperty1)Companion.CODEC.1.6.INSTANCE, arg_0)), (App)USES_CODEC.optionalFieldOf("max_uses", (Object)-1).forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$12((KProperty1)Companion.CODEC.1.7.INSTANCE, arg_0)), (App)CONDITION_CODEC.forGetter(arg_0 -> LootablePool.CODEC$lambda$14$lambda$13((KProperty1)Companion.CODEC.1.8.INSTANCE, arg_0))).apply((Applicative)instance, (p0$id, p1$rarity, p2$entry, p3$guaranteed, p4$description, p5$weight, p6$maxUses, p7$conditions) -> new LootablePool((class_2960)p0$id, (LootableRarity)((Object)p1$rarity), (LootablePoolEntry)p2$entry, (boolean)p3$guaranteed, (Optional<class_2561>)p4$description, (Optional<Integer>)p5$weight, (int)p6$maxUses, (List<? extends class_5341>)p7$conditions));
    }

    private static final DataResult REFERENCE_CODEC$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DataResult)$tmp0.invoke(p0);
    }

    private static final class_2960 REFERENCE_CODEC$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (class_2960)$tmp0.invoke(p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$17(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$18(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$19(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$20(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$21(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$22(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional DATA_MAP_CODEC$lambda$25$lambda$23(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Boolean DATA_MAP_CODEC$lambda$25$lambda$24(KProperty1 $tmp0, Companion.PoolData p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App DATA_MAP_CODEC$lambda$25(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)LootableRarity.Companion.getCODEC$lootables().optionalFieldOf("rarity").forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$17((KProperty1)Companion.DATA_MAP_CODEC.1.1.INSTANCE, arg_0)), (App)LootablePoolEntry.Companion.getCODEC().optionalFieldOf("entry").forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$18((KProperty1)Companion.DATA_MAP_CODEC.1.2.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("guaranteed").forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$19((KProperty1)Companion.DATA_MAP_CODEC.1.3.INSTANCE, arg_0)), (App)class_8824.field_46597.optionalFieldOf("desc").forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$20((KProperty1)Companion.DATA_MAP_CODEC.1.4.INSTANCE, arg_0)), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).optionalFieldOf("weight").orElse(Optional.empty()).forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$21((KProperty1)Companion.DATA_MAP_CODEC.1.5.INSTANCE, arg_0)), (App)Codec.INT.optionalFieldOf("max_uses").forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$22((KProperty1)Companion.DATA_MAP_CODEC.1.6.INSTANCE, arg_0)), (App)OPTIONAL_CONDITION_CODEC.forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$23((KProperty1)Companion.DATA_MAP_CODEC.1.7.INSTANCE, arg_0)), (App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(arg_0 -> LootablePool.DATA_MAP_CODEC$lambda$25$lambda$24((KProperty1)Companion.DATA_MAP_CODEC.1.8.INSTANCE, arg_0))).apply((Applicative)instance, Companion.PoolData::new);
    }

    private static final class_2960 LOADER_CODEC$lambda$28$lambda$26(KProperty1 $tmp0, Companion.PoolLoader p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (class_2960)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Companion.PoolData LOADER_CODEC$lambda$28$lambda$27(KProperty1 $tmp0, Companion.PoolLoader p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Companion.PoolData)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App LOADER_CODEC$lambda$28(RecordCodecBuilder.Instance instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        return instance.group((App)class_2960.field_25139.fieldOf("id").forGetter(arg_0 -> LootablePool.LOADER_CODEC$lambda$28$lambda$26((KProperty1)Companion.LOADER_CODEC.1.1.INSTANCE, arg_0)), (App)DATA_MAP_CODEC.forGetter(arg_0 -> LootablePool.LOADER_CODEC$lambda$28$lambda$27((KProperty1)Companion.LOADER_CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, Companion.PoolLoader::new);
    }

    public /* synthetic */ LootablePool(class_2960 id, LootableRarity rarity, LootablePoolEntry entry, boolean guaranteed, Optional description, Optional weight, int maxUses, List conditions, DefaultConstructorMarker $constructor_marker) {
        this(id, rarity, entry, guaranteed, description, weight, maxUses, conditions);
    }

    public static final /* synthetic */ Optional access$getDescription$p(LootablePool $this) {
        return $this.description;
    }

    public static final /* synthetic */ Optional access$getWeight$p(LootablePool $this) {
        return $this.weight;
    }

    public static final /* synthetic */ int access$getMaxUses$p(LootablePool $this) {
        return $this.maxUses;
    }

    public static final /* synthetic */ List access$getConditions$p(LootablePool $this) {
        return $this.conditions;
    }

    static {
        MapCodec mapCodec = new EitherMapCodec(class_5341.field_51809.listOf().optionalFieldOf("conditions", (Object)CollectionsKt.emptyList()), class_5341.field_51809.optionalFieldOf("condition")).xmap(arg_0 -> LootablePool.CONDITION_CODEC$lambda$0(Companion.CONDITION_CODEC.1.INSTANCE, arg_0), arg_0 -> LootablePool.CONDITION_CODEC$lambda$1(Companion.CONDITION_CODEC.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"xmap(...)");
        CONDITION_CODEC = mapCodec;
        mapCodec = new EitherMapCodec(class_5341.field_51809.listOf().optionalFieldOf("conditions"), class_5341.field_51809.optionalFieldOf("condition")).xmap(arg_0 -> LootablePool.OPTIONAL_CONDITION_CODEC$lambda$2(Companion.OPTIONAL_CONDITION_CODEC.1.INSTANCE, arg_0), arg_0 -> LootablePool.OPTIONAL_CONDITION_CODEC$lambda$3(Companion.OPTIONAL_CONDITION_CODEC.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"xmap(...)");
        OPTIONAL_CONDITION_CODEC = mapCodec;
        checker = LootablePool::checker$lambda$5;
        Codec codec = Codec.INT.flatXmap(checker, checker);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"flatXmap(...)");
        USES_CODEC = codec;
        Codec codec2 = RecordCodecBuilder.create(LootablePool::CODEC$lambda$14);
        Intrinsics.checkNotNullExpressionValue((Object)codec2, (String)"create(...)");
        CODEC = codec2;
        mapCodec = class_2960.field_25139.comapFlatMap(arg_0 -> LootablePool.REFERENCE_CODEC$lambda$15(Companion.REFERENCE_CODEC.1.INSTANCE, arg_0), arg_0 -> LootablePool.REFERENCE_CODEC$lambda$16(Companion.REFERENCE_CODEC.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"comapFlatMap(...)");
        REFERENCE_CODEC = mapCodec;
        MapCodec mapCodec2 = RecordCodecBuilder.mapCodec(LootablePool::DATA_MAP_CODEC$lambda$25);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec2, (String)"mapCodec(...)");
        DATA_MAP_CODEC = mapCodec2;
        Codec codec3 = DATA_MAP_CODEC.codec();
        Intrinsics.checkNotNullExpressionValue((Object)codec3, (String)"codec(...)");
        DATA_CODEC = codec3;
        Codec codec4 = RecordCodecBuilder.create(LootablePool::LOADER_CODEC$lambda$28);
        Intrinsics.checkNotNullExpressionValue((Object)codec4, (String)"create(...)");
        LOADER_CODEC = codec4;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001:\u0002BCB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J#\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b \u0010\u0003J1\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000\"\"\u0004\b\u0000\u0010!*\b\u0012\u0004\u0012\u00028\u00000\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\"\u00a2\u0006\u0004\b$\u0010%R\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R \u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u001c0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u001d\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060&8\u0006\u00a2\u0006\f\n\u0004\b/\u0010(\u001a\u0004\b0\u0010*R\u001d\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060+8\u0006\u00a2\u0006\f\n\u0004\b1\u0010.\u001a\u0004\b2\u00103R\u001d\u00105\u001a\b\u0012\u0004\u0012\u0002040&8\u0006\u00a2\u0006\f\n\u0004\b5\u0010(\u001a\u0004\b6\u0010*R&\u00107\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020,0\u001c0\"0+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u0010.R\u001d\u00108\u001a\b\u0012\u0004\u0012\u00020\f0&8\u0006\u00a2\u0006\f\n\u0004\b8\u0010(\u001a\u0004\b9\u0010*R\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001a0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010(R&\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0<0;8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u001c\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00050?8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010A\u00a8\u0006D"}, d2={"Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion;", "", "<init>", "()V", "", "Lnet/minecraft/class_2960;", "Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "loaders", "Ljava/util/function/Consumer;", "", "errorReporter", "Ljava/util/concurrent/ConcurrentMap;", "Lme/fzzyhmstrs/lootables/loot/LootablePool;", "bake", "(Ljava/util/Map;Ljava/util/function/Consumer;)Ljava/util/concurrent/ConcurrentMap;", "id", "d", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "create", "(Lnet/minecraft/class_2960;Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;", "entry", "createRandomPool", "(Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;)Lme/fzzyhmstrs/lootables/loot/LootablePool;", "Lnet/minecraft/class_3222;", "playerEntity", "", "meanSize", "", "createRandomPools", "(Lnet/minecraft/class_3222;I)Ljava/util/List;", "", "reset", "T", "Ljava/util/Optional;", "other", "otherwise", "(Ljava/util/Optional;Ljava/util/Optional;)Ljava/util/Optional;", "Lcom/mojang/serialization/Codec;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/class_5341;", "CONDITION_CODEC", "Lcom/mojang/serialization/MapCodec;", "DATA_CODEC", "getDATA_CODEC", "DATA_MAP_CODEC", "getDATA_MAP_CODEC", "()Lcom/mojang/serialization/MapCodec;", "Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolLoader;", "LOADER_CODEC", "getLOADER_CODEC", "OPTIONAL_CONDITION_CODEC", "REFERENCE_CODEC", "getREFERENCE_CODEC", "USES_CODEC", "Ljava/util/function/Function;", "Lcom/mojang/serialization/DataResult;", "checker", "Ljava/util/function/Function;", "", "seenIds", "Ljava/util/Set;", "PoolData", "PoolLoader", "lootables"})
    @SourceDebugExtension(value={"SMAP\nLootablePool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootablePool.kt\nme/fzzyhmstrs/lootables/loot/LootablePool$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1557#2:242\n1628#2,3:243\n*S KotlinDebug\n*F\n+ 1 LootablePool.kt\nme/fzzyhmstrs/lootables/loot/LootablePool$Companion\n*L\n140#1:242\n140#1:243,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void reset() {
            seenIds = new LinkedHashSet();
        }

        @NotNull
        public final ConcurrentMap<class_2960, LootablePool> bake(@NotNull Map<class_2960, PoolData> loaders, @NotNull Consumer<String> errorReporter) {
            Intrinsics.checkNotNullParameter(loaders, (String)"loaders");
            Intrinsics.checkNotNullParameter(errorReporter, (String)"errorReporter");
            ConcurrentMap map2 = new ConcurrentHashMap((int)((float)loaders.size() / 0.95f) + 2, 0.95f);
            List errors = new ArrayList();
            for (Map.Entry<class_2960, PoolData> entry : loaders.entrySet()) {
                PoolData d;
                class_2960 id = entry.getKey();
                ValidationResult result2 = ValidationResult.Companion.report(this.create(id, d = entry.getValue()), errors);
                if (!result2.isValid()) continue;
                ((Map)map2).put(id, result2.get());
            }
            errors.forEach(errorReporter);
            return map2;
        }

        @NotNull
        public final ValidationResult<LootablePool> create(@NotNull class_2960 id, @NotNull PoolData d) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            if (seenIds.contains(id)) {
                return ValidationResult.Companion.error(null, "LootablePool with ID " + id + " already created!");
            }
            seenIds.add(id);
            if (d.getEntry().isEmpty()) {
                return ValidationResult.Companion.error(null, "Entry required for pool " + id);
            }
            LootableRarity rarity = d.getRarity().orElse(LootableRarity.COMMON);
            LootablePoolEntry lootablePoolEntry = d.getEntry().get();
            Intrinsics.checkNotNullExpressionValue((Object)lootablePoolEntry, (String)"get(...)");
            LootablePoolEntry entry = lootablePoolEntry;
            Boolean guaranteed = d.getGuaranteed().orElse(false);
            Integer maxUses = d.getMaxUses().orElse(-1);
            List<class_5341> conditions = d.getConditions().orElse(CollectionsKt.emptyList());
            Intrinsics.checkNotNull((Object)((Object)rarity));
            Intrinsics.checkNotNull((Object)guaranteed);
            boolean bl = guaranteed;
            Optional<class_2561> optional = d.getDescription();
            Optional<Integer> optional2 = d.getWeight();
            Intrinsics.checkNotNull((Object)maxUses);
            int n = maxUses;
            Intrinsics.checkNotNull(conditions);
            return ValidationResult.Companion.success((Object)new LootablePool(id, rarity, entry, bl, optional, optional2, n, conditions, null));
        }

        private final LootablePool createRandomPool(LootablePoolEntry entry) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            class_2960 class_29602 = Lootables.INSTANCE.identity(string2);
            LootableRarity lootableRarity = (LootableRarity)((Object)EntriesMappings.entries$0.get(Lootables.INSTANCE.random().method_43048(EntriesMappings.entries$0.size())));
            boolean bl = Lootables.INSTANCE.random().method_43056();
            Optional optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            Optional optional2 = Lootables.INSTANCE.random().method_43056() ? Optional.empty() : Optional.of(Lootables.INSTANCE.random().method_43048(12) + 1);
            Intrinsics.checkNotNull(optional2);
            return new LootablePool(class_29602, lootableRarity, entry, bl, optional, optional2, Lootables.INSTANCE.random().method_43056() ? -1 : Lootables.INSTANCE.random().method_43048(100) + 1, null, 128, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<LootablePool> createRandomPools(@NotNull class_3222 playerEntity, int meanSize) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
            Iterable $this$map$iv = LootablePoolEntryType.Companion.randomList(playerEntity, meanSize);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LootablePoolEntry lootablePoolEntry = (LootablePoolEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.createRandomPool((LootablePoolEntry)it));
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final <T> Optional<T> otherwise(@NotNull Optional<T> $this$otherwise, @NotNull Optional<T> other) {
            Intrinsics.checkNotNullParameter($this$otherwise, (String)"<this>");
            Intrinsics.checkNotNullParameter(other, (String)"other");
            return $this$otherwise.isPresent() ? $this$otherwise : other;
        }

        @NotNull
        public final Codec<LootablePool> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final Codec<LootablePool> getREFERENCE_CODEC() {
            return REFERENCE_CODEC;
        }

        @NotNull
        public final MapCodec<PoolData> getDATA_MAP_CODEC() {
            return DATA_MAP_CODEC;
        }

        @NotNull
        public final Codec<PoolData> getDATA_CODEC() {
            return DATA_CODEC;
        }

        @NotNull
        public final Codec<PoolLoader> getLOADER_CODEC() {
            return LOADER_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<LootableRarity> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])LootableRarity.values());
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u00002\u00020\u0001By\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0002\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002\u0012\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0002\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0015J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u0015J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u001c\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u0010\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0090\u0001\u0010!\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00022\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00022\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00022\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b!\u0010\"J\u001a\u0010#\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b#\u0010$J\u0010\u0010%\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b%\u0010&J\u0010\u0010(\u001a\u00020'H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010)R#\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010*\u001a\u0004\b+\u0010\u0015R\u001d\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u00028\u0006\u00a2\u0006\f\n\u0004\b\n\u0010*\u001a\u0004\b,\u0010\u0015R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010*\u001a\u0004\b-\u0010\u0015R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00028\u0006\u00a2\u0006\f\n\u0004\b\b\u0010*\u001a\u0004\b.\u0010\u0015R\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00028\u0006\u00a2\u0006\f\n\u0004\b\r\u0010*\u001a\u0004\b/\u0010\u0015R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010*\u001a\u0004\b0\u0010\u0015R\u0017\u0010\u0011\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0011\u00101\u001a\u0004\b2\u0010\u001dR\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00028\u0006\u00a2\u0006\f\n\u0004\b\f\u0010*\u001a\u0004\b3\u0010\u0015\u00a8\u00064"}, d2={"Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "", "Ljava/util/Optional;", "Lme/fzzyhmstrs/lootables/loot/LootableRarity;", "rarity", "Lme/fzzyhmstrs/lootables/loot/LootablePoolEntry;", "entry", "", "guaranteed", "Lnet/minecraft/class_2561;", "description", "", "weight", "maxUses", "", "Lnet/minecraft/class_5341;", "conditions", "replace", "<init>", "(Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Z)V", "component1", "()Ljava/util/Optional;", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "()Z", "other", "composite", "(Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;)Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "copy", "(Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Ljava/util/Optional;Z)Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Optional;", "getConditions", "getDescription", "getEntry", "getGuaranteed", "getMaxUses", "getRarity", "Z", "getReplace", "getWeight", "lootables"})
        public static final class PoolData {
            @NotNull
            private final Optional<LootableRarity> rarity;
            @NotNull
            private final Optional<LootablePoolEntry> entry;
            @NotNull
            private final Optional<Boolean> guaranteed;
            @NotNull
            private final Optional<class_2561> description;
            @NotNull
            private final Optional<Integer> weight;
            @NotNull
            private final Optional<Integer> maxUses;
            @NotNull
            private final Optional<List<class_5341>> conditions;
            private final boolean replace;

            public PoolData(@NotNull Optional<LootableRarity> rarity, @NotNull Optional<LootablePoolEntry> entry, @NotNull Optional<Boolean> guaranteed, @NotNull Optional<class_2561> description, @NotNull Optional<Integer> weight, @NotNull Optional<Integer> maxUses, @NotNull Optional<List<class_5341>> conditions, boolean replace) {
                Intrinsics.checkNotNullParameter(rarity, (String)"rarity");
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                Intrinsics.checkNotNullParameter(guaranteed, (String)"guaranteed");
                Intrinsics.checkNotNullParameter(description, (String)"description");
                Intrinsics.checkNotNullParameter(weight, (String)"weight");
                Intrinsics.checkNotNullParameter(maxUses, (String)"maxUses");
                Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
                this.rarity = rarity;
                this.entry = entry;
                this.guaranteed = guaranteed;
                this.description = description;
                this.weight = weight;
                this.maxUses = maxUses;
                this.conditions = conditions;
                this.replace = replace;
            }

            public /* synthetic */ PoolData(Optional optional, Optional optional2, Optional optional3, Optional optional4, Optional optional5, Optional optional6, Optional optional7, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x80) != 0) {
                    bl = false;
                }
                this(optional, optional2, optional3, optional4, optional5, optional6, optional7, bl);
            }

            @NotNull
            public final Optional<LootableRarity> getRarity() {
                return this.rarity;
            }

            @NotNull
            public final Optional<LootablePoolEntry> getEntry() {
                return this.entry;
            }

            @NotNull
            public final Optional<Boolean> getGuaranteed() {
                return this.guaranteed;
            }

            @NotNull
            public final Optional<class_2561> getDescription() {
                return this.description;
            }

            @NotNull
            public final Optional<Integer> getWeight() {
                return this.weight;
            }

            @NotNull
            public final Optional<Integer> getMaxUses() {
                return this.maxUses;
            }

            @NotNull
            public final Optional<List<class_5341>> getConditions() {
                return this.conditions;
            }

            public final boolean getReplace() {
                return this.replace;
            }

            @NotNull
            public final PoolData composite(@NotNull PoolData other) {
                Intrinsics.checkNotNullParameter((Object)other, (String)"other");
                Optional<LootableRarity> r = Companion.otherwise(other.rarity, this.rarity);
                Optional<LootablePoolEntry> e = Companion.otherwise(other.entry, this.entry);
                Optional<Boolean> g = Companion.otherwise(other.guaranteed, this.guaranteed);
                Optional<class_2561> d = Companion.otherwise(other.description, this.description);
                Optional<Integer> w = Companion.otherwise(other.weight, this.weight);
                Optional<Integer> m = Companion.otherwise(other.maxUses, this.maxUses);
                Optional<List<class_5341>> c = Companion.otherwise(other.conditions, this.conditions);
                return new PoolData(r, e, g, d, w, m, c, false);
            }

            @NotNull
            public final Optional<LootableRarity> component1() {
                return this.rarity;
            }

            @NotNull
            public final Optional<LootablePoolEntry> component2() {
                return this.entry;
            }

            @NotNull
            public final Optional<Boolean> component3() {
                return this.guaranteed;
            }

            @NotNull
            public final Optional<class_2561> component4() {
                return this.description;
            }

            @NotNull
            public final Optional<Integer> component5() {
                return this.weight;
            }

            @NotNull
            public final Optional<Integer> component6() {
                return this.maxUses;
            }

            @NotNull
            public final Optional<List<class_5341>> component7() {
                return this.conditions;
            }

            public final boolean component8() {
                return this.replace;
            }

            @NotNull
            public final PoolData copy(@NotNull Optional<LootableRarity> rarity, @NotNull Optional<LootablePoolEntry> entry, @NotNull Optional<Boolean> guaranteed, @NotNull Optional<class_2561> description, @NotNull Optional<Integer> weight, @NotNull Optional<Integer> maxUses, @NotNull Optional<List<class_5341>> conditions, boolean replace) {
                Intrinsics.checkNotNullParameter(rarity, (String)"rarity");
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                Intrinsics.checkNotNullParameter(guaranteed, (String)"guaranteed");
                Intrinsics.checkNotNullParameter(description, (String)"description");
                Intrinsics.checkNotNullParameter(weight, (String)"weight");
                Intrinsics.checkNotNullParameter(maxUses, (String)"maxUses");
                Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
                return new PoolData(rarity, entry, guaranteed, description, weight, maxUses, conditions, replace);
            }

            public static /* synthetic */ PoolData copy$default(PoolData poolData, Optional optional, Optional optional2, Optional optional3, Optional optional4, Optional optional5, Optional optional6, Optional optional7, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    optional = poolData.rarity;
                }
                if ((n & 2) != 0) {
                    optional2 = poolData.entry;
                }
                if ((n & 4) != 0) {
                    optional3 = poolData.guaranteed;
                }
                if ((n & 8) != 0) {
                    optional4 = poolData.description;
                }
                if ((n & 0x10) != 0) {
                    optional5 = poolData.weight;
                }
                if ((n & 0x20) != 0) {
                    optional6 = poolData.maxUses;
                }
                if ((n & 0x40) != 0) {
                    optional7 = poolData.conditions;
                }
                if ((n & 0x80) != 0) {
                    bl = poolData.replace;
                }
                return poolData.copy(optional, optional2, optional3, optional4, optional5, optional6, optional7, bl);
            }

            @NotNull
            public String toString() {
                return "PoolData(rarity=" + this.rarity + ", entry=" + this.entry + ", guaranteed=" + this.guaranteed + ", description=" + this.description + ", weight=" + this.weight + ", maxUses=" + this.maxUses + ", conditions=" + this.conditions + ", replace=" + this.replace + ")";
            }

            public int hashCode() {
                int result2 = this.rarity.hashCode();
                result2 = result2 * 31 + this.entry.hashCode();
                result2 = result2 * 31 + this.guaranteed.hashCode();
                result2 = result2 * 31 + this.description.hashCode();
                result2 = result2 * 31 + this.weight.hashCode();
                result2 = result2 * 31 + this.maxUses.hashCode();
                result2 = result2 * 31 + this.conditions.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.replace);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PoolData)) {
                    return false;
                }
                PoolData poolData = (PoolData)other;
                if (!Intrinsics.areEqual(this.rarity, poolData.rarity)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.entry, poolData.entry)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.guaranteed, poolData.guaranteed)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.description, poolData.description)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.weight, poolData.weight)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.maxUses, poolData.maxUses)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.conditions, poolData.conditions)) {
                    return false;
                }
                return this.replace == poolData.replace;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001b\u0010\u000e\u001a\u00020\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00000\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ$\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0018\u001a\u00020\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u001dH\u00d6\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u000bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010\t\u00a8\u0006$"}, d2={"Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolLoader;", "", "Lnet/minecraft/class_2960;", "id", "Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "data", "<init>", "(Lnet/minecraft/class_2960;Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;)V", "component1", "()Lnet/minecraft/class_2960;", "component2", "()Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "Ljava/util/Optional;", "o", "composite", "(Ljava/util/Optional;)Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolLoader;", "copy", "(Lnet/minecraft/class_2960;Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;)Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolLoader;", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Lme/fzzyhmstrs/lootables/loot/LootablePool;", "create", "()Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lme/fzzyhmstrs/lootables/loot/LootablePool$Companion$PoolData;", "getData", "Lnet/minecraft/class_2960;", "getId", "lootables"})
        public static final class PoolLoader {
            @NotNull
            private final class_2960 id;
            @NotNull
            private final PoolData data;

            public PoolLoader(@NotNull class_2960 id, @NotNull PoolData data) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.id = id;
                this.data = data;
            }

            @NotNull
            public final class_2960 getId() {
                return this.id;
            }

            @NotNull
            public final PoolData getData() {
                return this.data;
            }

            @NotNull
            public final PoolLoader composite(@NotNull Optional<PoolLoader> o) {
                Intrinsics.checkNotNullParameter(o, (String)"o");
                if (o.isEmpty()) {
                    return this;
                }
                PoolLoader poolLoader = o.get();
                Intrinsics.checkNotNullExpressionValue((Object)poolLoader, (String)"get(...)");
                PoolLoader other = poolLoader;
                PoolData d = this.data.composite(other.data);
                return new PoolLoader(this.id, d);
            }

            @NotNull
            public final ValidationResult<LootablePool> create() {
                return Companion.create(this.id, this.data);
            }

            @NotNull
            public final class_2960 component1() {
                return this.id;
            }

            @NotNull
            public final PoolData component2() {
                return this.data;
            }

            @NotNull
            public final PoolLoader copy(@NotNull class_2960 id, @NotNull PoolData data) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                return new PoolLoader(id, data);
            }

            public static /* synthetic */ PoolLoader copy$default(PoolLoader poolLoader, class_2960 class_29602, PoolData poolData, int n, Object object) {
                if ((n & 1) != 0) {
                    class_29602 = poolLoader.id;
                }
                if ((n & 2) != 0) {
                    poolData = poolLoader.data;
                }
                return poolLoader.copy(class_29602, poolData);
            }

            @NotNull
            public String toString() {
                return "PoolLoader(id=" + this.id + ", data=" + this.data + ")";
            }

            public int hashCode() {
                int result2 = this.id.hashCode();
                result2 = result2 * 31 + this.data.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof PoolLoader)) {
                    return false;
                }
                PoolLoader poolLoader = (PoolLoader)other;
                if (!Intrinsics.areEqual((Object)this.id, (Object)poolLoader.id)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.data, (Object)poolLoader.data);
            }
        }
    }
}

