/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.lootables.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.lootables.Lootables;
import me.fzzyhmstrs.lootables.api.IdKey;
import me.fzzyhmstrs.lootables.data.LootablesData;
import me.fzzyhmstrs.lootables.data.SyncDataHolder;
import me.fzzyhmstrs.lootables.loot.LootablePool;
import me.fzzyhmstrs.lootables.loot.LootablePoolData;
import me.fzzyhmstrs.lootables.loot.LootablePoolEntry;
import me.fzzyhmstrs.lootables.loot.LootableTable;
import me.fzzyhmstrs.lootables.network.AbortChoicesC2SCustomPayload;
import me.fzzyhmstrs.lootables.network.ChosenC2SCustomPayload;
import me.fzzyhmstrs.lootables.network.DataSyncS2CCustomPayload;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5455;
import net.minecraft.class_6860;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002ijB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u0018J\u001d\u0010 \u001a\u00020\u001f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b#\u0010$J\u0013\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160%\u00a2\u0006\u0004\b&\u0010'J\u001d\u0010)\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010,\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020\b\u00a2\u0006\u0004\b.\u0010\u0003J\u001d\u0010/\u001a\u00020+2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b/\u00100J!\u00102\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001501H\u0002\u00a2\u0006\u0004\b2\u00103J\u000f\u00105\u001a\u000204H\u0002\u00a2\u0006\u0004\b5\u00106J\u001d\u0010;\u001a\u00020\b2\u0006\u00108\u001a\u0002072\u0006\u0010:\u001a\u000209\u00a2\u0006\u0004\b;\u0010<J\u001d\u0010=\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b=\u0010\u0013J\u000f\u0010>\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b>\u0010\u0003J\u000f\u0010?\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b?\u0010\u0003Je\u0010F\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010A\u001a\u00020@2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020@0C2\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020@0C\u00a2\u0006\u0004\bF\u0010GJ\u001d\u0010H\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\bH\u0010IJ7\u0010N\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000M0L\"\u0004\b\u0000\u0010J*\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00028\u00000KH\u0002\u00a2\u0006\u0004\bN\u0010OR\u0014\u0010P\u001a\u00020(8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u001a\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00100R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0016\u0010U\u001a\u00020+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u001c\u0010Y\u001a\n X*\u0004\u0018\u00010W0W8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\"\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001a0K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\"\u0010_\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\"0K8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010\\R \u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020`018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\ba\u0010\\R-\u0010e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u00103R\u001b\u0010h\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bf\u0010c\u001a\u0004\bg\u00106\u00a8\u0006k"}, d2={"Lme/fzzyhmstrs/lootables/data/LootablesData;", "", "<init>", "()V", "Lme/fzzyhmstrs/lootables/network/AbortChoicesC2SCustomPayload;", "payload", "Lnet/minecraft/class_3222;", "playerEntity", "", "applyAbort", "(Lme/fzzyhmstrs/lootables/network/AbortChoicesC2SCustomPayload;Lnet/minecraft/class_3222;)V", "Lme/fzzyhmstrs/lootables/network/ChosenC2SCustomPayload;", "applyChosen", "(Lme/fzzyhmstrs/lootables/network/ChosenC2SCustomPayload;Lnet/minecraft/class_3222;)V", "Lme/fzzyhmstrs/lootables/api/IdKey;", "key", "Ljava/util/UUID;", "uuid", "applyKey", "(Lme/fzzyhmstrs/lootables/api/IdKey;Ljava/util/UUID;)V", "choiceKey", "", "Lnet/minecraft/class_2960;", "getPendingPools", "(Ljava/util/UUID;)Ljava/util/List;", "id", "Lme/fzzyhmstrs/lootables/loot/LootablePool;", "getPool", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/lootables/loot/LootablePool;", "getStoredPools", "players", "Lme/fzzyhmstrs/lootables/data/SyncDataHolder;", "getSyncData", "(Ljava/util/List;)Lme/fzzyhmstrs/lootables/data/SyncDataHolder;", "Lme/fzzyhmstrs/lootables/loot/LootableTable;", "getTable", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/lootables/loot/LootableTable;", "", "getTableIds", "()Ljava/util/Set;", "", "getUses", "(Lnet/minecraft/class_2960;Ljava/util/UUID;)I", "", "hasTable", "(Lnet/minecraft/class_2960;)Z", "init", "keyAvailable", "(Lme/fzzyhmstrs/lootables/api/IdKey;Ljava/util/UUID;)Z", "", "loadStoredChoices", "()Ljava/util/Map;", "Lme/fzzyhmstrs/lootables/data/LootablesData$UsageData;", "loadUsageData", "()Lme/fzzyhmstrs/lootables/data/LootablesData$UsageData;", "Lnet/minecraft/class_3300;", "manager", "Lnet/minecraft/class_7225$class_7874;", "dynamicRegistries", "reload", "(Lnet/minecraft/class_3300;Lnet/minecraft/class_7225$class_7874;)V", "retractKey", "saveStoredChoices", "saveUsageData", "Lnet/minecraft/class_243;", "pos", "poolChoices", "Ljava/util/function/BiConsumer;", "onSuccess", "onAbort", "setPending", "(Ljava/util/UUID;Lnet/minecraft/class_3222;Lnet/minecraft/class_243;Ljava/util/List;Lme/fzzyhmstrs/lootables/api/IdKey;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)V", "use", "(Lnet/minecraft/class_2960;Ljava/util/UUID;)V", "T", "", "Ljava/util/stream/Stream;", "", "ifStream", "(Ljava/util/Map;)Ljava/util/stream/Stream;", "PARALLEL_BREAKPOINT", "I", "", "abortedChoices", "Ljava/util/Set;", "dataInvalid", "Z", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "lootablePools", "Ljava/util/Map;", "lootableSyncData", "Lme/fzzyhmstrs/lootables/data/SyncDataHolder;", "lootableTables", "Lme/fzzyhmstrs/lootables/data/LootablesData$PendingChoices;", "pendingChoicesMap", "storedChoices$delegate", "Lkotlin/Lazy;", "getStoredChoices", "storedChoices", "usageData$delegate", "getUsageData", "usageData", "PendingChoices", "UsageData", "lootables"})
@SourceDebugExtension(value={"SMAP\nLootablesData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LootablesData.kt\nme/fzzyhmstrs/lootables/data/LootablesData\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,508:1\n216#2,2:509\n216#2,2:513\n1246#3,2:511\n1246#3,4:516\n1249#3:520\n412#4:515\n*S KotlinDebug\n*F\n+ 1 LootablesData.kt\nme/fzzyhmstrs/lootables/data/LootablesData\n*L\n62#1:509,2\n70#1:513,2\n66#1:511,2\n71#1:516,4\n66#1:520\n71#1:515\n*E\n"})
public final class LootablesData {
    @NotNull
    public static final LootablesData INSTANCE = new LootablesData();
    @NotNull
    private static Map<class_2960, LootablePool> lootablePools = MapsKt.emptyMap();
    @NotNull
    private static Map<class_2960, LootableTable> lootableTables = MapsKt.emptyMap();
    private static boolean dataInvalid = true;
    @NotNull
    private static SyncDataHolder lootableSyncData = SyncDataHolder.Empty.INSTANCE;
    @NotNull
    private static final Map<UUID, PendingChoices> pendingChoicesMap = new LinkedHashMap();
    @NotNull
    private static final Set<UUID> abortedChoices = new LinkedHashSet();
    @NotNull
    private static final Lazy storedChoices$delegate = LazyKt.lazy((Function0)storedChoices.2.INSTANCE);
    @NotNull
    private static final Lazy usageData$delegate = LazyKt.lazy((Function0)usageData.2.INSTANCE);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final int PARALLEL_BREAKPOINT = 512;

    private LootablesData() {
    }

    private final Map<UUID, List<class_2960>> getStoredChoices() {
        Lazy lazy = storedChoices$delegate;
        return (Map)lazy.getValue();
    }

    private final UsageData getUsageData() {
        Lazy lazy = usageData$delegate;
        return (UsageData)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final SyncDataHolder getSyncData(List<? extends class_3222> players) {
        if (dataInvalid) {
            void $this$associateByTo$iv;
            Map<class_2960, LootableTable> $this$forEach$iv = lootableTables;
            boolean $i$f$forEach = false;
            Object iterable = $this$forEach$iv.entrySet().iterator();
            while (iterable.hasNext()) {
                Map.Entry<class_2960, LootableTable> entry;
                Map.Entry<class_2960, LootableTable> it = entry = iterable.next();
                boolean bl = false;
                it.getValue().preSync(LootablePoolEntry.InvalidationType.INIT);
            }
            boolean b = false;
            iterable = players;
            Map map2 = new ConcurrentHashMap((int)((float)players.size() / 0.95f), 1.0f);
            boolean $i$f$associateByTo = false;
            for (Object element$iv3 : $this$associateByTo$iv) {
                void $this$mapValuesTo$iv;
                class_3222 class_32222 = (class_3222)element$iv3;
                Map map3 = map2;
                boolean bl = false;
                class_3222 p = (class_3222)element$iv3;
                void var28_37 = p;
                boolean bl2 = false;
                Map<class_2960, LootableTable> $this$forEach$iv2 = lootableTables;
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<class_2960, LootableTable>> iterator = $this$forEach$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<class_2960, LootableTable> element$iv4;
                    Map.Entry<class_2960, LootableTable> it = element$iv4 = iterator.next();
                    boolean bl3 = false;
                    b = b || it.getValue().preSync(LootablePoolEntry.InvalidationType.PLAYER);
                }
                $this$forEach$iv2 = lootableTables;
                Map destination$iv2 = new ConcurrentHashMap((int)((float)lootableTables.size() / 0.95f), 1.0f);
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapValuesTo$iv.entrySet();
                boolean $i$f$associateByTo2 = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    Map map4 = destination$iv2;
                    boolean bl4 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    Object k = it$iv.getKey();
                    Map map5 = map4;
                    boolean bl5 = false;
                    LootableTable tables = (LootableTable)entry2.getValue();
                    List<LootablePoolData> list = tables.sync(p);
                    map5.put(k, list);
                }
                ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)destination$iv2;
                map3.put(var28_37, concurrentHashMap);
            }
            Map m = map2;
            lootableSyncData = SyncDataHolder.Companion.create(b, m);
            dataInvalid = false;
        }
        return lootableSyncData;
    }

    @Nullable
    public final LootablePool getPool(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return lootablePools.get(id);
    }

    public final boolean hasTable(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return lootableTables.containsKey(id);
    }

    @Nullable
    public final LootableTable getTable(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return lootableTables.get(id);
    }

    @NotNull
    public final Set<class_2960> getTableIds() {
        return lootableTables.keySet();
    }

    public final int getUses(@NotNull class_2960 id, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map<UUID, Integer> map2 = this.getUsageData().getUsesMap().get(id);
        return map2 != null && (map2 = map2.get(uuid)) != null ? (Integer)((Object)map2) : 0;
    }

    public final void use(@NotNull class_2960 id, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map map2 = this.getUsageData().getUsesMap().computeIfAbsent(id, arg_0 -> LootablesData.use$lambda$5(use.map.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        Map map3 = map2;
        Integer n = (Integer)map3.get(uuid);
        int uses = n != null ? n : 0;
        map3.put(uuid, uses + 1);
    }

    public final boolean keyAvailable(@NotNull IdKey key, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map<UUID, Integer> map2 = this.getUsageData().getKeyMap().get(key.getId());
        return (map2 != null && (map2 = map2.get(uuid)) != null ? (Integer)((Object)map2) : 0) < key.getCount();
    }

    public final void applyKey(@NotNull IdKey key, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map map2 = this.getUsageData().getKeyMap().computeIfAbsent(key.getId(), arg_0 -> LootablesData.applyKey$lambda$6(applyKey.map.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        Map map3 = map2;
        Integer n = (Integer)map3.get(uuid);
        int uses = n != null ? n : 0;
        map3.put(uuid, Math.min(uses + 1, key.getCount()));
    }

    public final void retractKey(@NotNull IdKey key, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Map map2 = this.getUsageData().getKeyMap().computeIfAbsent(key.getId(), arg_0 -> LootablesData.retractKey$lambda$7(retractKey.map.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"computeIfAbsent(...)");
        Map map3 = map2;
        Integer n = (Integer)map3.get(uuid);
        int uses = n != null ? n : 0;
        map3.put(uuid, Math.max(uses - 1, 0));
    }

    public final void applyChosen(@NotNull ChosenC2SCustomPayload payload, @NotNull class_3222 playerEntity) {
        PendingChoices pending;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        PendingChoices pendingChoices = pending = pendingChoicesMap.get(payload.getChoiceKey());
        if (pendingChoices != null) {
            pendingChoices.succeed(playerEntity);
        }
        LootableTable lootableTable = this.getTable(payload.getTable());
        if (lootableTable != null) {
            List<class_2960> list = payload.getChosen();
            PendingChoices pendingChoices2 = pending;
            if (pendingChoices2 == null || (pendingChoices2 = pendingChoices2.getPos()) == null) {
                pendingChoices2 = class_243.field_1353;
            }
            PendingChoices pendingChoices3 = pendingChoices2;
            Intrinsics.checkNotNull((Object)pendingChoices3);
            lootableTable.applyPoolsById(list, playerEntity, (class_243)pendingChoices3);
        }
        pendingChoicesMap.remove(payload.getChoiceKey());
    }

    public final void applyAbort(@NotNull AbortChoicesC2SCustomPayload payload, @NotNull class_3222 playerEntity) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        if (abortedChoices.contains(payload.getChoiceKey())) {
            return;
        }
        PendingChoices pendingChoices = pendingChoicesMap.get(payload.getChoiceKey());
        if (pendingChoices == null) {
            return;
        }
        PendingChoices pending = pendingChoices;
        pending.abort(playerEntity);
        if (pending.getKey() != null) {
            IdKey idKey = pending.getKey();
            UUID uUID = playerEntity.method_5667();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
            this.retractKey(idKey, uUID);
        }
        abortedChoices.add(payload.getChoiceKey());
    }

    public final void setPending(@NotNull UUID choiceKey, @NotNull class_3222 playerEntity, @NotNull class_243 pos, @NotNull List<class_2960> poolChoices, @Nullable IdKey key, @NotNull BiConsumer<class_3222, class_243> onSuccess, @NotNull BiConsumer<class_3222, class_243> onAbort) {
        Intrinsics.checkNotNullParameter((Object)choiceKey, (String)"choiceKey");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter(poolChoices, (String)"poolChoices");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onAbort, (String)"onAbort");
        Map<UUID, PendingChoices> map2 = pendingChoicesMap;
        UUID uUID = playerEntity.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        PendingChoices pendingChoices = new PendingChoices(uUID, pos, poolChoices, key, onSuccess, onAbort);
        map2.put(choiceKey, pendingChoices);
    }

    @Nullable
    public final List<class_2960> getPendingPools(@NotNull UUID choiceKey) {
        Intrinsics.checkNotNullParameter((Object)choiceKey, (String)"choiceKey");
        PendingChoices pendingChoices = pendingChoicesMap.get(choiceKey);
        if (pendingChoices == null) {
            return null;
        }
        PendingChoices pending = pendingChoices;
        abortedChoices.remove(choiceKey);
        return pending.getPoolChoices();
    }

    @Nullable
    public final List<class_2960> getStoredPools(@NotNull UUID choiceKey) {
        Intrinsics.checkNotNullParameter((Object)choiceKey, (String)"choiceKey");
        List<class_2960> list = this.getStoredChoices().get(choiceKey);
        if (list == null) {
            return null;
        }
        List<class_2960> stored = list;
        this.getStoredChoices().remove(choiceKey);
        return stored;
    }

    private final UsageData loadUsageData() {
        try {
            Map map2;
            Map map3;
            File dir = ConfigApi.platform().gameDir();
            File f = new File(dir, "lootables_uses.json");
            if (!f.exists()) {
                return new UsageData(new LinkedHashMap(), new LinkedHashMap());
            }
            String str = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)f, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            if (((CharSequence)str).length() == 0) {
                return new UsageData(new LinkedHashMap(), new LinkedHashMap());
            }
            JsonElement json = JsonParser.parseString((String)str);
            if (!json.isJsonObject()) {
                Lootables.INSTANCE.getLOGGER().error("Lootables usage data file was malformed. Using empty map.");
                return new UsageData(new LinkedHashMap(), new LinkedHashMap());
            }
            JsonElement keyMapJson = json.getAsJsonObject().get("key_map");
            if (!keyMapJson.isJsonObject()) {
                Lootables.INSTANCE.getLOGGER().error("Lootables key map was malformed. Using empty map.");
                map3 = new LinkedHashMap();
            } else {
                Map keyMapTemp = new LinkedHashMap();
                for (Map.Entry entry : keyMapJson.getAsJsonObject().entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    String idStr = (String)entry.getKey();
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!element.isJsonObject()) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables key map encountered read error for element " + idStr + ". Not an object");
                        continue;
                    }
                    class_2960 id = class_2960.method_12829((String)idStr);
                    if (id == null) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables key map encountered read error for element " + idStr + ". Not an object");
                        continue;
                    }
                    Map elementMap = new LinkedHashMap();
                    for (Map.Entry entry2 : element.getAsJsonObject().entrySet()) {
                        Intrinsics.checkNotNull((Object)entry2);
                        String uuidStr = (String)entry2.getKey();
                        JsonElement elementElement = (JsonElement)entry2.getValue();
                        UUID uuid = UUID.fromString(uuidStr);
                        int usages = elementElement.getAsInt();
                        Integer n = usages;
                        Intrinsics.checkNotNull((Object)uuid);
                        elementMap.put(uuid, n);
                    }
                    keyMapTemp.put(id, elementMap);
                }
                map3 = keyMapTemp;
            }
            Map keyMap = map3;
            JsonElement usesMapJson = json.getAsJsonObject().get("uses_map");
            if (!usesMapJson.isJsonObject()) {
                Lootables.INSTANCE.getLOGGER().error("Lootables usage map was malformed. Using empty data.");
                map2 = new LinkedHashMap();
            } else {
                Map usesMapTemp = new LinkedHashMap();
                for (Map.Entry entry : usesMapJson.getAsJsonObject().entrySet()) {
                    Intrinsics.checkNotNull((Object)entry);
                    String idStr = (String)entry.getKey();
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!element.isJsonObject()) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables usage map encountered read error for element " + idStr + ". Not an object");
                        continue;
                    }
                    class_2960 id = class_2960.method_12829((String)idStr);
                    if (id == null) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables usage map encountered read error for element " + idStr + ". Not an object");
                        continue;
                    }
                    Map elementMap = new LinkedHashMap();
                    for (Map.Entry entry3 : element.getAsJsonObject().entrySet()) {
                        Intrinsics.checkNotNull((Object)entry3);
                        String uuidStr = (String)entry3.getKey();
                        JsonElement elementElement = (JsonElement)entry3.getValue();
                        UUID uuid = UUID.fromString(uuidStr);
                        int usages = elementElement.getAsInt();
                        Integer n = usages;
                        Intrinsics.checkNotNull((Object)uuid);
                        elementMap.put(uuid, n);
                    }
                    usesMapTemp.put(id, elementMap);
                }
                map2 = usesMapTemp;
            }
            Map usesMap = map2;
            return new UsageData(usesMap, keyMap);
        }
        catch (Throwable e) {
            Lootables.INSTANCE.getLOGGER().error("Critical exception encountered while reading lootables usage data. Using empty data.");
            e.printStackTrace();
            return new UsageData(new LinkedHashMap(), new LinkedHashMap());
        }
    }

    private final void saveUsageData() {
        if (this.getUsageData().isEmpty()) {
            return;
        }
        try {
            File dir = ConfigApi.platform().gameDir();
            File f = new File(dir, "lootables_uses.json");
            JsonObject json = new JsonObject();
            JsonObject keyJson = new JsonObject();
            for (Map.Entry<class_2960, Map<UUID, Integer>> object : this.getUsageData().getKeyMap().entrySet()) {
                class_2960 class_29602 = object.getKey();
                Map<UUID, Integer> map2 = object.getValue();
                JsonObject mapJson = new JsonObject();
                for (Map.Entry<UUID, Integer> entry : map2.entrySet()) {
                    UUID uUID = entry.getKey();
                    int uses = ((Number)entry.getValue()).intValue();
                    mapJson.add(uUID.toString(), (JsonElement)new JsonPrimitive((Number)uses));
                }
                keyJson.add(class_29602.toString(), (JsonElement)mapJson);
            }
            json.add("key_map", (JsonElement)keyJson);
            JsonObject usesJson = new JsonObject();
            for (Map.Entry<class_2960, Map<UUID, Integer>> entry : this.getUsageData().getUsesMap().entrySet()) {
                class_2960 id = entry.getKey();
                Map<UUID, Integer> map3 = entry.getValue();
                JsonObject mapJson = new JsonObject();
                for (Map.Entry<UUID, Integer> entry2 : map3.entrySet()) {
                    UUID uuid = entry2.getKey();
                    int uses = ((Number)entry2.getValue()).intValue();
                    mapJson.add(uuid.toString(), (JsonElement)new JsonPrimitive((Number)uses));
                }
                usesJson.add(id.toString(), (JsonElement)mapJson);
            }
            json.add("uses_map", (JsonElement)usesJson);
            if (f.exists()) {
                String string = gson.toJson((JsonElement)json);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                FilesKt.writeText$default((File)f, (String)string, null, (int)2, null);
            } else if (f.createNewFile()) {
                String string = gson.toJson((JsonElement)json);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                FilesKt.writeText$default((File)f, (String)string, null, (int)2, null);
            } else {
                Lootables.INSTANCE.getLOGGER().error("Couldn't create new lootables_uses json; data wasn't saved.");
            }
        }
        catch (Throwable e) {
            Lootables.INSTANCE.getLOGGER().error("Critical exception encountered while saving lootables usage data. Not saved.");
            e.printStackTrace();
        }
    }

    private final Map<UUID, List<class_2960>> loadStoredChoices() {
        try {
            File dir = ConfigApi.platform().gameDir();
            File f = new File(dir, "lootables_choices.json");
            if (!f.exists()) {
                return new LinkedHashMap();
            }
            String str = CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)f, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            if (((CharSequence)str).length() == 0) {
                return new LinkedHashMap();
            }
            JsonElement json = JsonParser.parseString((String)str);
            if (!json.isJsonObject()) {
                Lootables.INSTANCE.getLOGGER().error("Lootables stored choices file was malformed. Using empty map.");
                return new LinkedHashMap();
            }
            Map map2 = new LinkedHashMap();
            for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                Intrinsics.checkNotNull((Object)entry);
                String uuidStr = (String)entry.getKey();
                JsonElement element = (JsonElement)entry.getValue();
                if (!element.isJsonArray()) {
                    Lootables.INSTANCE.getLOGGER().error("Lootables stored choices encountered read error for element " + uuidStr + ". Not an array");
                    continue;
                }
                UUID uuid = UUID.fromString(uuidStr);
                List list = new ArrayList();
                for (JsonElement idElement : element.getAsJsonArray()) {
                    if (!idElement.isJsonPrimitive()) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables stored choices encountered read error for list in element " + uuidStr + ". Not a string");
                        continue;
                    }
                    class_2960 id = class_2960.method_12829((String)idElement.getAsString());
                    if (id == null) {
                        Lootables.INSTANCE.getLOGGER().error("Lootables stored choices encountered read error for list in element " + uuidStr + ". Not a valid identifier");
                        continue;
                    }
                    list.add(id);
                }
                Intrinsics.checkNotNull((Object)uuid);
                map2.put(uuid, list);
            }
            return map2;
        }
        catch (Exception e) {
            Lootables.INSTANCE.getLOGGER().error("Critical exception encountered while reading lootables stored choices.");
            e.printStackTrace();
            return new LinkedHashMap();
        }
    }

    private final void saveStoredChoices() {
        if (this.getStoredChoices().isEmpty()) {
            return;
        }
        try {
            File dir = ConfigApi.platform().gameDir();
            File f = new File(dir, "lootables_choices.json");
            JsonObject json = new JsonObject();
            for (Map.Entry<UUID, PendingChoices> entry : pendingChoicesMap.entrySet()) {
                UUID uuid = entry.getKey();
                PendingChoices pendingChoices = entry.getValue();
                JsonArray jsonArray = new JsonArray();
                for (class_2960 choice : pendingChoices.getPoolChoices()) {
                    jsonArray.add(choice.toString());
                }
                json.add(uuid.toString(), (JsonElement)jsonArray);
            }
            if (f.exists()) {
                String string = gson.toJson((JsonElement)json);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                FilesKt.writeText$default((File)f, (String)string, null, (int)2, null);
            } else if (f.createNewFile()) {
                String string = gson.toJson((JsonElement)json);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
                FilesKt.writeText$default((File)f, (String)string, null, (int)2, null);
            } else {
                Lootables.INSTANCE.getLOGGER().error("Couldn't create new lootables_choices json; data wasn't saved.");
            }
        }
        catch (Throwable e) {
            Lootables.INSTANCE.getLOGGER().error("Critical exception encountered while saving lootables stored choice data. Not saved.");
            e.printStackTrace();
        }
    }

    private final <T> Stream<Map.Entry<class_2960, T>> ifStream(Map<class_2960, ? extends T> $this$ifStream) {
        Stream<Map.Entry<class_2960, T>> stream;
        if ($this$ifStream.size() < 512) {
            Stream<Map.Entry<class_2960, T>> stream2 = $this$ifStream.entrySet().stream();
            Intrinsics.checkNotNull(stream2);
            stream = stream2;
        } else {
            Stream stream3 = $this$ifStream.entrySet().parallelStream();
            Intrinsics.checkNotNull(stream3);
            stream = stream3;
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void reload(@NotNull class_3300 manager, @NotNull class_7225.class_7874 dynamicRegistries) {
        void it;
        void it2;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)dynamicRegistries, (String)"dynamicRegistries");
        dataInvalid = true;
        lootableSyncData = SyncDataHolder.Empty.INSTANCE;
        LootablePool.Companion.reset();
        Lootables.INSTANCE.getLOGGER().info("Starting lootables table load");
        long start = System.currentTimeMillis();
        class_6903 ops = dynamicRegistries.method_57093((DynamicOps)JsonOps.INSTANCE);
        Ref.ObjectRef poolMap = new Ref.ObjectRef();
        Map map3 = map2 = manager.method_14488("lootable_pool", LootablesData::reload$lambda$8);
        LootablesData lootablesData = this;
        boolean $i$a$-also-LootablesData$reload$32 = false;
        poolMap.element = it2.size() < 512 ? (Map)new ConcurrentHashMap((int)((float)it2.size() / 0.95f + (float)2), 0.95f) : (Map)new ConcurrentHashMap((int)((float)it2.size() / 0.95f + (float)2), 0.95f, ForkJoinPool.getCommonPoolParallelism());
        Map map4 = map2;
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"also(...)");
        lootablesData.ifStream(map4).forEach(arg_0 -> LootablesData.reload$lambda$10((Function1)new Function1<Map.Entry<? extends class_2960, ? extends class_3298>, Unit>((class_6903<JsonElement>)ops, (Ref.ObjectRef<Map<class_2960, LootablePool.Companion.PoolData>>)poolMap){
            final /* synthetic */ class_6903<JsonElement> $ops;
            final /* synthetic */ Ref.ObjectRef<Map<class_2960, LootablePool.Companion.PoolData>> $poolMap;
            {
                this.$ops = $ops;
                this.$poolMap = $poolMap;
                super(1);
            }

            public final void invoke(Map.Entry<class_2960, ? extends class_3298> entry) {
                Intrinsics.checkNotNull(entry);
                class_2960 id = entry.getKey();
                class_3298 resource = entry.getValue();
                try {
                    BufferedReader reader = resource.method_43039();
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    DataResult result2 = LootablePool.Companion.getDATA_CODEC().parse((DynamicOps)this.$ops, (Object)json);
                    String string = id.method_12832();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"lootable_pool/", (boolean)false, (int)2, null)) {
                        Lootables.INSTANCE.getLOGGER().error("Invalid resource location for lootable pool " + id + "; needs to be in 'lootable_pool' folder");
                    } else {
                        String string2 = id.method_12836();
                        String string3 = id.method_12832();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        String string4 = string3;
                        int n = 14;
                        int n2 = id.method_12832().length() - 5;
                        String string5 = string4.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        class_2960 poolId = class_2960.method_60655((String)string2, (String)string5);
                        result2.ifSuccess(arg_0 -> reload.3.invoke$lambda$0((Function1)new Function1<LootablePool.Companion.PoolData, Unit>(this.$poolMap, poolId){
                            final /* synthetic */ Ref.ObjectRef<Map<class_2960, LootablePool.Companion.PoolData>> $poolMap;
                            final /* synthetic */ class_2960 $poolId;
                            {
                                this.$poolMap = $poolMap;
                                this.$poolId = $poolId;
                                super(1);
                            }

                            public final void invoke(LootablePool.Companion.PoolData data) {
                                if (data.getReplace()) {
                                    Map map2 = (Map)this.$poolMap.element;
                                    class_2960 class_29602 = this.$poolId;
                                    Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"$poolId");
                                    class_2960 class_29603 = class_29602;
                                    Intrinsics.checkNotNull((Object)data);
                                    LootablePool.Companion.PoolData poolData = data;
                                    map2.put(class_29603, poolData);
                                } else {
                                    ((Map)this.$poolMap.element).compute(this.$poolId, (arg_0, arg_1) -> reload.1.invoke$lambda$0((Function2)new Function2<class_2960, LootablePool.Companion.PoolData, LootablePool.Companion.PoolData>(data){
                                        final /* synthetic */ LootablePool.Companion.PoolData $data;
                                        {
                                            this.$data = $data;
                                            super(2);
                                        }

                                        @Nullable
                                        public final LootablePool.Companion.PoolData invoke(@NotNull class_2960 class_29602, @Nullable LootablePool.Companion.PoolData d) {
                                            LootablePool.Companion.PoolData poolData;
                                            block3: {
                                                block2: {
                                                    Intrinsics.checkNotNullParameter((Object)class_29602, (String)"<anonymous parameter 0>");
                                                    poolData = d;
                                                    if (poolData == null) break block2;
                                                    LootablePool.Companion.PoolData poolData2 = this.$data;
                                                    Intrinsics.checkNotNullExpressionValue((Object)poolData2, (String)"$data");
                                                    if ((poolData = poolData.composite(poolData2)) != null) break block3;
                                                }
                                                poolData = this.$data;
                                            }
                                            return poolData;
                                        }
                                    }, arg_0, arg_1));
                                }
                            }

                            private static final LootablePool.Companion.PoolData invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                return (LootablePool.Companion.PoolData)$tmp0.invoke(p0, p1);
                            }
                        }, arg_0)).ifError(arg_0 -> reload.3.invoke$lambda$1(reload.2.INSTANCE, arg_0));
                    }
                }
                catch (Throwable e) {
                    Lootables.INSTANCE.getLOGGER().error("Error parsing lootable pool " + id);
                    e.printStackTrace();
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        lootablePools = LootablePool.Companion.bake((Map)poolMap.element, arg_0 -> ((Logger)Lootables.INSTANCE.getLOGGER()).error(arg_0));
        Ref.ObjectRef tableMap = new Ref.ObjectRef();
        Map $i$a$-also-LootablesData$reload$32 = map3 = manager.method_14488("lootable_table", LootablesData::reload$lambda$11);
        lootablesData = this;
        boolean bl = false;
        tableMap.element = it.size() < 512 ? (Map)new ConcurrentHashMap((int)((float)it.size() / 0.95f + (float)2), 0.95f) : (Map)new ConcurrentHashMap((int)((float)it.size() / 0.95f + (float)2), 0.95f, ForkJoinPool.getCommonPoolParallelism());
        Map map5 = map3;
        Intrinsics.checkNotNullExpressionValue((Object)map5, (String)"also(...)");
        lootablesData.ifStream(map5).forEach(arg_0 -> LootablesData.reload$lambda$13((Function1)new Function1<Map.Entry<? extends class_2960, ? extends class_3298>, Unit>((class_6903<JsonElement>)ops, (Ref.ObjectRef<Map<class_2960, LootableTable.Companion.TableLoader>>)tableMap){
            final /* synthetic */ class_6903<JsonElement> $ops;
            final /* synthetic */ Ref.ObjectRef<Map<class_2960, LootableTable.Companion.TableLoader>> $tableMap;
            {
                this.$ops = $ops;
                this.$tableMap = $tableMap;
                super(1);
            }

            public final void invoke(Map.Entry<class_2960, ? extends class_3298> entry) {
                Intrinsics.checkNotNull(entry);
                class_2960 id = entry.getKey();
                class_3298 resource = entry.getValue();
                try {
                    BufferedReader reader = resource.method_43039();
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    DataResult result2 = LootableTable.Companion.getLOADER_CODEC$lootables().parse((DynamicOps)this.$ops, (Object)json);
                    String string = id.method_12832();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    if (!StringsKt.startsWith$default((String)string, (String)"lootable_table/", (boolean)false, (int)2, null)) {
                        Lootables.INSTANCE.getLOGGER().error("Invalid resource location for lootable table " + id + "; needs to be in 'lootable_table' folder");
                    } else {
                        String string2 = id.method_12836();
                        String string3 = id.method_12832();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                        String string4 = string3;
                        int n = 15;
                        int n2 = id.method_12832().length() - 5;
                        String string5 = string4.substring(n, n2);
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                        class_2960 tableId = class_2960.method_60655((String)string2, (String)string5);
                        result2.ifSuccess(arg_0 -> reload.7.invoke$lambda$0((Function1)new Function1<LootableTable.Companion.TableLoader, Unit>(this.$tableMap, tableId){
                            final /* synthetic */ Ref.ObjectRef<Map<class_2960, LootableTable.Companion.TableLoader>> $tableMap;
                            final /* synthetic */ class_2960 $tableId;
                            {
                                this.$tableMap = $tableMap;
                                this.$tableId = $tableId;
                                super(1);
                            }

                            public final void invoke(LootableTable.Companion.TableLoader table) {
                                if (table.getReplace()) {
                                    Map map2 = (Map)this.$tableMap.element;
                                    class_2960 class_29602 = this.$tableId;
                                    Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"$tableId");
                                    class_2960 class_29603 = class_29602;
                                    Intrinsics.checkNotNull((Object)table);
                                    LootableTable.Companion.TableLoader tableLoader = table;
                                    map2.put(class_29603, tableLoader);
                                } else {
                                    ((Map)this.$tableMap.element).compute(this.$tableId, (arg_0, arg_1) -> reload.1.invoke$lambda$0((Function2)new Function2<class_2960, LootableTable.Companion.TableLoader, LootableTable.Companion.TableLoader>(table){
                                        final /* synthetic */ LootableTable.Companion.TableLoader $table;
                                        {
                                            this.$table = $table;
                                            super(2);
                                        }

                                        @Nullable
                                        public final LootableTable.Companion.TableLoader invoke(@NotNull class_2960 class_29602, @Nullable LootableTable.Companion.TableLoader loader) {
                                            LootableTable.Companion.TableLoader tableLoader;
                                            block3: {
                                                block2: {
                                                    Intrinsics.checkNotNullParameter((Object)class_29602, (String)"<anonymous parameter 0>");
                                                    tableLoader = loader;
                                                    if (tableLoader == null) break block2;
                                                    LootableTable.Companion.TableLoader tableLoader2 = this.$table;
                                                    Intrinsics.checkNotNullExpressionValue((Object)tableLoader2, (String)"$table");
                                                    if ((tableLoader = tableLoader.composite(tableLoader2)) != null) break block3;
                                                }
                                                tableLoader = this.$table;
                                            }
                                            return tableLoader;
                                        }
                                    }, arg_0, arg_1));
                                }
                            }

                            private static final LootableTable.Companion.TableLoader invoke$lambda$0(Function2 $tmp0, Object p0, Object p1) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                return (LootableTable.Companion.TableLoader)$tmp0.invoke(p0, p1);
                            }
                        }, arg_0)).ifError(arg_0 -> reload.7.invoke$lambda$1(reload.2.INSTANCE, arg_0));
                    }
                }
                catch (Throwable e) {
                    Lootables.INSTANCE.getLOGGER().error("Error parsing lootable table " + id);
                    e.printStackTrace();
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
        lootableTables = LootableTable.Companion.bake$lootables((Map)tableMap.element, arg_0 -> ((Logger)Lootables.INSTANCE.getLOGGER()).error(arg_0));
        Lootables.INSTANCE.getLOGGER().info("Finished lootable table load in " + (System.currentTimeMillis() - start) + "ms");
        LootablePool.Companion.reset();
    }

    public final void init() {
        ServerLifecycleEvents.BEFORE_SAVE.register(LootablesData::init$lambda$14);
        ServerLifecycleEvents.SERVER_STARTING.register(LootablesData::init$lambda$15);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register(LootablesData::init$lambda$19);
        ServerPlayConnectionEvents.JOIN.register(LootablesData::init$lambda$22);
        ServerPlayConnectionEvents.DISCONNECT.register(LootablesData::init$lambda$23);
        ServerLifecycleEvents.SERVER_STOPPING.register(LootablesData::init$lambda$24);
    }

    private static final Map use$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map applyKey$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final Map retractKey$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final boolean reload$lambda$8(class_2960 path) {
        String string = path.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    private static final void reload$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean reload$lambda$11(class_2960 path) {
        String string = path.method_12832();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.endsWith$default((String)string, (String)".json", (boolean)false, (int)2, null);
    }

    private static final void reload$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void init$lambda$14(MinecraftServer minecraftServer, boolean bl, boolean bl2) {
        INSTANCE.saveUsageData();
    }

    private static final void init$lambda$15(MinecraftServer server) {
        class_3300 class_33002 = server.method_34864();
        Intrinsics.checkNotNullExpressionValue((Object)class_33002, (String)"getResourceManager(...)");
        class_5455.class_6890 class_68902 = server.method_58576().method_58289();
        Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"getRegistryManager(...)");
        INSTANCE.reload(class_33002, (class_7225.class_7874)class_68902);
        server.method_3816();
    }

    private static final Unit init$lambda$19$lambda$16(class_6860 $resourceManager, MinecraftServer $server) {
        Intrinsics.checkNotNull((Object)$resourceManager);
        class_3300 class_33002 = (class_3300)$resourceManager;
        class_5455.class_6890 class_68902 = $server.method_58576().method_58289();
        Intrinsics.checkNotNullExpressionValue((Object)class_68902, (String)"getRegistryManager(...)");
        INSTANCE.reload(class_33002, (class_7225.class_7874)class_68902);
        return Unit.INSTANCE;
    }

    private static final SyncDataHolder init$lambda$19$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SyncDataHolder)$tmp0.invoke(p0);
    }

    private static final void init$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void init$lambda$19(MinecraftServer server, class_6860 resourceManager, boolean bl) {
        if (server.method_3760().method_14571().isEmpty()) {
            return;
        }
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> LootablesData.init$lambda$19$lambda$16(resourceManager, server)).thenApplyAsync(arg_0 -> LootablesData.init$lambda$19$lambda$17((Function1)new Function1<Unit, SyncDataHolder>(server){
            final /* synthetic */ MinecraftServer $server;
            {
                this.$server = $server;
                super(1);
            }

            public final SyncDataHolder invoke(Unit it) {
                List list = this.$server.method_3760().method_14571();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
                return LootablesData.access$getSyncData(LootablesData.INSTANCE, list);
            }
        }, arg_0))).thenAccept(arg_0 -> LootablesData.init$lambda$19$lambda$18((Function1)new Function1<SyncDataHolder, Unit>(server){
            final /* synthetic */ MinecraftServer $server;
            {
                this.$server = $server;
                super(1);
            }

            public final void invoke(SyncDataHolder sd) {
                List list = this.$server.method_3760().method_14571();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
                sd.forEachPlayer(list, init.3.3::invoke$lambda$0);
            }

            private static final void invoke$lambda$0(class_3222 p, Map m) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                ConfigApi.INSTANCE.network().send((class_8710)new DataSyncS2CCustomPayload(m), (class_1657)p);
            }
        }, arg_0));
    }

    private static final SyncDataHolder init$lambda$22$lambda$20(MinecraftServer $server) {
        List list = $server.method_3760().method_14571();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayerList(...)");
        return INSTANCE.getSyncData(list);
    }

    private static final void init$lambda$22$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void init$lambda$22(class_3244 handler, PacketSender packetSender, MinecraftServer server) {
        CompletableFuture.supplyAsync(() -> LootablesData.init$lambda$22$lambda$20(server)).thenAccept(arg_0 -> LootablesData.init$lambda$22$lambda$21((Function1)new Function1<SyncDataHolder, Unit>(handler){
            final /* synthetic */ class_3244 $handler;
            {
                this.$handler = $handler;
                super(1);
            }

            public final void invoke(SyncDataHolder sd) {
                class_3222 class_32222 = this.$handler.method_32311();
                Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
                sd.forPlayer(class_32222, init.4.2::invoke$lambda$0);
            }

            private static final void invoke$lambda$0(class_3222 p, Map m) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                ConfigApi.INSTANCE.network().send((class_8710)new DataSyncS2CCustomPayload(m), (class_1657)p);
            }
        }, arg_0));
    }

    private static final void init$lambda$23(class_3244 handler, MinecraftServer minecraftServer) {
        for (Map.Entry<UUID, PendingChoices> entry : pendingChoicesMap.entrySet()) {
            UUID uuid = entry.getKey();
            PendingChoices pendingChoices = entry.getValue();
            if (!Intrinsics.areEqual((Object)pendingChoices.getPlayerUuid(), (Object)handler.method_32311().method_5667())) continue;
            class_3222 class_32222 = handler.method_32311();
            Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
            pendingChoices.abort(class_32222);
            INSTANCE.getStoredChoices().put(uuid, pendingChoices.getPoolChoices());
        }
    }

    private static final void init$lambda$24(MinecraftServer server) {
        for (Map.Entry<UUID, PendingChoices> entry : pendingChoicesMap.entrySet()) {
            class_3222 player;
            UUID uuid = entry.getKey();
            PendingChoices pendingChoices = entry.getValue();
            if (server.method_3760().method_14602(pendingChoices.getPlayerUuid()) == null) continue;
            pendingChoices.abort(player);
            INSTANCE.getStoredChoices().put(uuid, pendingChoices.getPoolChoices());
        }
        INSTANCE.saveStoredChoices();
    }

    public static final /* synthetic */ SyncDataHolder access$getSyncData(LootablesData $this, List players) {
        return $this.getSyncData(players);
    }

    public static final /* synthetic */ Map access$loadStoredChoices(LootablesData $this) {
        return $this.loadStoredChoices();
    }

    public static final /* synthetic */ UsageData access$loadUsageData(LootablesData $this) {
        return $this.loadUsageData();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\b\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\tH\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001c\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010\u001eJl\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t2\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0001\u00a2\u0006\u0004\b \u0010!J\u001a\u0010$\u001a\u00020#2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010'\u001a\u00020&H\u00d6\u0001\u00a2\u0006\u0004\b'\u0010(J\u0015\u0010)\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\f\u00a2\u0006\u0004\b)\u0010\u0014J\u0010\u0010+\u001a\u00020*H\u00d6\u0001\u00a2\u0006\u0004\b+\u0010,R\u0019\u0010\n\u001a\u0004\u0018\u00010\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010-\u001a\u0004\b.\u0010\u001cR#\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010/\u001a\u0004\b0\u0010\u001eR#\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u000b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010/\u001a\u0004\b1\u0010\u001eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00102\u001a\u0004\b3\u0010\u0016R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u00104\u001a\u0004\b5\u0010\u001aR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u00106\u001a\u0004\b7\u0010\u0018\u00a8\u00068"}, d2={"Lme/fzzyhmstrs/lootables/data/LootablesData$PendingChoices;", "", "Ljava/util/UUID;", "playerUuid", "Lnet/minecraft/class_243;", "pos", "", "Lnet/minecraft/class_2960;", "poolChoices", "Lme/fzzyhmstrs/lootables/api/IdKey;", "key", "Ljava/util/function/BiConsumer;", "Lnet/minecraft/class_3222;", "onSuccess", "onAbort", "<init>", "(Ljava/util/UUID;Lnet/minecraft/class_243;Ljava/util/List;Lme/fzzyhmstrs/lootables/api/IdKey;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)V", "playerEntity", "", "abort", "(Lnet/minecraft/class_3222;)V", "component1", "()Ljava/util/UUID;", "component2", "()Lnet/minecraft/class_243;", "component3", "()Ljava/util/List;", "component4", "()Lme/fzzyhmstrs/lootables/api/IdKey;", "component5", "()Ljava/util/function/BiConsumer;", "component6", "copy", "(Ljava/util/UUID;Lnet/minecraft/class_243;Ljava/util/List;Lme/fzzyhmstrs/lootables/api/IdKey;Ljava/util/function/BiConsumer;Ljava/util/function/BiConsumer;)Lme/fzzyhmstrs/lootables/data/LootablesData$PendingChoices;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "succeed", "", "toString", "()Ljava/lang/String;", "Lme/fzzyhmstrs/lootables/api/IdKey;", "getKey", "Ljava/util/function/BiConsumer;", "getOnAbort", "getOnSuccess", "Ljava/util/UUID;", "getPlayerUuid", "Ljava/util/List;", "getPoolChoices", "Lnet/minecraft/class_243;", "getPos", "lootables"})
    private static final class PendingChoices {
        @NotNull
        private final UUID playerUuid;
        @NotNull
        private final class_243 pos;
        @NotNull
        private final List<class_2960> poolChoices;
        @Nullable
        private final IdKey key;
        @NotNull
        private final BiConsumer<class_3222, class_243> onSuccess;
        @NotNull
        private final BiConsumer<class_3222, class_243> onAbort;

        public PendingChoices(@NotNull UUID playerUuid, @NotNull class_243 pos, @NotNull List<class_2960> poolChoices, @Nullable IdKey key, @NotNull BiConsumer<class_3222, class_243> onSuccess, @NotNull BiConsumer<class_3222, class_243> onAbort) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(poolChoices, (String)"poolChoices");
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onAbort, (String)"onAbort");
            this.playerUuid = playerUuid;
            this.pos = pos;
            this.poolChoices = poolChoices;
            this.key = key;
            this.onSuccess = onSuccess;
            this.onAbort = onAbort;
        }

        @NotNull
        public final UUID getPlayerUuid() {
            return this.playerUuid;
        }

        @NotNull
        public final class_243 getPos() {
            return this.pos;
        }

        @NotNull
        public final List<class_2960> getPoolChoices() {
            return this.poolChoices;
        }

        @Nullable
        public final IdKey getKey() {
            return this.key;
        }

        @NotNull
        public final BiConsumer<class_3222, class_243> getOnSuccess() {
            return this.onSuccess;
        }

        @NotNull
        public final BiConsumer<class_3222, class_243> getOnAbort() {
            return this.onAbort;
        }

        public final void succeed(@NotNull class_3222 playerEntity) {
            Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
            this.onSuccess.accept(playerEntity, this.pos);
        }

        public final void abort(@NotNull class_3222 playerEntity) {
            Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
            this.onAbort.accept(playerEntity, this.pos);
        }

        @NotNull
        public final UUID component1() {
            return this.playerUuid;
        }

        @NotNull
        public final class_243 component2() {
            return this.pos;
        }

        @NotNull
        public final List<class_2960> component3() {
            return this.poolChoices;
        }

        @Nullable
        public final IdKey component4() {
            return this.key;
        }

        @NotNull
        public final BiConsumer<class_3222, class_243> component5() {
            return this.onSuccess;
        }

        @NotNull
        public final BiConsumer<class_3222, class_243> component6() {
            return this.onAbort;
        }

        @NotNull
        public final PendingChoices copy(@NotNull UUID playerUuid, @NotNull class_243 pos, @NotNull List<class_2960> poolChoices, @Nullable IdKey key, @NotNull BiConsumer<class_3222, class_243> onSuccess, @NotNull BiConsumer<class_3222, class_243> onAbort) {
            Intrinsics.checkNotNullParameter((Object)playerUuid, (String)"playerUuid");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(poolChoices, (String)"poolChoices");
            Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
            Intrinsics.checkNotNullParameter(onAbort, (String)"onAbort");
            return new PendingChoices(playerUuid, pos, poolChoices, key, onSuccess, onAbort);
        }

        public static /* synthetic */ PendingChoices copy$default(PendingChoices pendingChoices, UUID uUID, class_243 class_2432, List list, IdKey idKey, BiConsumer biConsumer, BiConsumer biConsumer2, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = pendingChoices.playerUuid;
            }
            if ((n & 2) != 0) {
                class_2432 = pendingChoices.pos;
            }
            if ((n & 4) != 0) {
                list = pendingChoices.poolChoices;
            }
            if ((n & 8) != 0) {
                idKey = pendingChoices.key;
            }
            if ((n & 0x10) != 0) {
                biConsumer = pendingChoices.onSuccess;
            }
            if ((n & 0x20) != 0) {
                biConsumer2 = pendingChoices.onAbort;
            }
            return pendingChoices.copy(uUID, class_2432, list, idKey, biConsumer, biConsumer2);
        }

        @NotNull
        public String toString() {
            return "PendingChoices(playerUuid=" + this.playerUuid + ", pos=" + this.pos + ", poolChoices=" + this.poolChoices + ", key=" + this.key + ", onSuccess=" + this.onSuccess + ", onAbort=" + this.onAbort + ")";
        }

        public int hashCode() {
            int result2 = this.playerUuid.hashCode();
            result2 = result2 * 31 + this.pos.hashCode();
            result2 = result2 * 31 + ((Object)this.poolChoices).hashCode();
            result2 = result2 * 31 + (this.key == null ? 0 : this.key.hashCode());
            result2 = result2 * 31 + this.onSuccess.hashCode();
            result2 = result2 * 31 + this.onAbort.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PendingChoices)) {
                return false;
            }
            PendingChoices pendingChoices = (PendingChoices)other;
            if (!Intrinsics.areEqual((Object)this.playerUuid, (Object)pendingChoices.playerUuid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)pendingChoices.pos)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.poolChoices, pendingChoices.poolChoices)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.key, (Object)pendingChoices.key)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.onSuccess, pendingChoices.onSuccess)) {
                return false;
            }
            return Intrinsics.areEqual(this.onAbort, pendingChoices.onAbort);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001BG\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002\u0012\u001e\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ(\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ(\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\u000bJT\u0010\r\u001a\u00020\u00002 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u00022 \b\u0002\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\r\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019R/\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u000bR/\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001c\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lme/fzzyhmstrs/lootables/data/LootablesData$UsageData;", "", "", "Lnet/minecraft/class_2960;", "Ljava/util/UUID;", "", "usesMap", "keyMap", "<init>", "(Ljava/util/Map;Ljava/util/Map;)V", "component1", "()Ljava/util/Map;", "component2", "copy", "(Ljava/util/Map;Ljava/util/Map;)Lme/fzzyhmstrs/lootables/data/LootablesData$UsageData;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getKeyMap", "getUsesMap", "lootables"})
    private static final class UsageData {
        @NotNull
        private final Map<class_2960, Map<UUID, Integer>> usesMap;
        @NotNull
        private final Map<class_2960, Map<UUID, Integer>> keyMap;

        public UsageData(@NotNull Map<class_2960, Map<UUID, Integer>> usesMap, @NotNull Map<class_2960, Map<UUID, Integer>> keyMap) {
            Intrinsics.checkNotNullParameter(usesMap, (String)"usesMap");
            Intrinsics.checkNotNullParameter(keyMap, (String)"keyMap");
            this.usesMap = usesMap;
            this.keyMap = keyMap;
        }

        @NotNull
        public final Map<class_2960, Map<UUID, Integer>> getUsesMap() {
            return this.usesMap;
        }

        @NotNull
        public final Map<class_2960, Map<UUID, Integer>> getKeyMap() {
            return this.keyMap;
        }

        public final boolean isEmpty() {
            return this.usesMap.isEmpty() && this.keyMap.isEmpty();
        }

        @NotNull
        public final Map<class_2960, Map<UUID, Integer>> component1() {
            return this.usesMap;
        }

        @NotNull
        public final Map<class_2960, Map<UUID, Integer>> component2() {
            return this.keyMap;
        }

        @NotNull
        public final UsageData copy(@NotNull Map<class_2960, Map<UUID, Integer>> usesMap, @NotNull Map<class_2960, Map<UUID, Integer>> keyMap) {
            Intrinsics.checkNotNullParameter(usesMap, (String)"usesMap");
            Intrinsics.checkNotNullParameter(keyMap, (String)"keyMap");
            return new UsageData(usesMap, keyMap);
        }

        public static /* synthetic */ UsageData copy$default(UsageData usageData2, Map map2, Map map3, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = usageData2.usesMap;
            }
            if ((n & 2) != 0) {
                map3 = usageData2.keyMap;
            }
            return usageData2.copy(map2, map3);
        }

        @NotNull
        public String toString() {
            return "UsageData(usesMap=" + this.usesMap + ", keyMap=" + this.keyMap + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.usesMap).hashCode();
            result2 = result2 * 31 + ((Object)this.keyMap).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UsageData)) {
                return false;
            }
            UsageData usageData2 = (UsageData)other;
            if (!Intrinsics.areEqual(this.usesMap, usageData2.usesMap)) {
                return false;
            }
            return Intrinsics.areEqual(this.keyMap, usageData2.keyMap);
        }
    }
}

