/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImpl;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEvents;
import me.fzzyhmstrs.fzzy_config.networking.NetworkEventsClient;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.registry.SyncedConfigRegistry;
import me.fzzyhmstrs.fzzy_config.util.ThreadingUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.extensions.ICommonPacketListener;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0015\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\u0015\u0010$\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020#\u00a2\u0006\u0004\b$\u0010%J\u0015\u0010'\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020&\u00a2\u0006\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/NetworkEvents;", "", "<init>", "()V", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "id", "", "canSend", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;)Z", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "payload", "", "send", "(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;", "Lnet/neoforged/neoforge/network/handling/IPayloadContext;", "context", "handleUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateC2SCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;", "handleSettingForwardBidirectional", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lnet/neoforged/neoforge/network/handling/IPayloadContext;)V", "handleSettingForward", "Lnet/neoforged/neoforge/event/OnDatapackSyncEvent;", "event", "registerDataSync", "(Lnet/neoforged/neoforge/event/OnDatapackSyncEvent;)V", "Lnet/neoforged/neoforge/network/event/RegisterConfigurationTasksEvent;", "registerConfigurations", "(Lnet/neoforged/neoforge/network/event/RegisterConfigurationTasksEvent;)V", "Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;", "registerPayloads", "(Lnet/neoforged/neoforge/network/event/RegisterPayloadHandlersEvent;)V", "Lnet/neoforged/neoforge/event/server/ServerStartedEvent;", "serverStarted", "(Lnet/neoforged/neoforge/event/server/ServerStartedEvent;)V", "Lnet/neoforged/neoforge/event/GameShuttingDownEvent;", "gameStopping", "(Lnet/neoforged/neoforge/event/GameShuttingDownEvent;)V", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nNetworkEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkEvents.kt\nme/fzzyhmstrs/fzzy_config/networking/NetworkEvents\n+ 2 fzzy_config.kt\nme/fzzyhmstrs/fzzy_config/Fzzy_configKt\n*L\n1#1,139:1\n31#2:140\n31#2:141\n31#2:142\n*S KotlinDebug\n*F\n+ 1 NetworkEvents.kt\nme/fzzyhmstrs/fzzy_config/networking/NetworkEvents\n*L\n45#1:140\n46#1:141\n66#1:142\n*E\n"})
public final class NetworkEvents {
    @NotNull
    public static final NetworkEvents INSTANCE = new NetworkEvents();

    private NetworkEvents() {
    }

    public final boolean canSend(@NotNull ServerPlayer playerEntity, @NotNull CustomPacketPayload.Type<?> id) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter(id, (String)"id");
        return NetworkRegistry.hasChannel((ICommonPacketListener)((ICommonPacketListener)playerEntity.connection), (ResourceLocation)id.id());
    }

    public final void send(@NotNull ServerPlayer playerEntity, @NotNull CustomPacketPayload payload) {
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        PacketDistributor.sendToPlayer((ServerPlayer)playerEntity, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private final void handleUpdate(ConfigUpdateC2SCustomPayload payload, IPayloadContext context) {
        Map<String, String> map = payload.getUpdates();
        Player $this$cast$iv = context.player();
        boolean $i$f$cast = false;
        Player player = $this$cast$iv;
        if (player == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
        }
        MinecraftServer minecraftServer = ((ServerPlayer)player).level().getServer();
        Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
        Player $this$cast$iv2 = context.player();
        boolean $i$f$cast2 = false;
        Player player2 = $this$cast$iv2;
        if (player2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
        }
        SyncedConfigRegistry.INSTANCE.receiveConfigUpdate$fzzy_config(map, minecraftServer, (ServerPlayer)player2, payload.getPlayerPerm(), payload.getChangeHistory(), NetworkEvents::handleUpdate$lambda$0, NetworkEvents::handleUpdate$lambda$1);
    }

    private final void handleSettingForwardBidirectional(SettingForwardCustomPayload payload, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            this.handleSettingForward(payload, context);
        } else {
            NetworkEventsClient.INSTANCE.handleSettingForward(payload, context);
        }
    }

    private final void handleSettingForward(SettingForwardCustomPayload payload, IPayloadContext context) {
        Player $this$cast$iv = context.player();
        boolean $i$f$cast = false;
        Player player = $this$cast$iv;
        if (player == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.server.network.ServerPlayerEntity");
        }
        SyncedConfigRegistry.INSTANCE.receiveSettingForward$fzzy_config(payload.getPlayer(), (ServerPlayer)player, payload.getScope(), payload.getUpdate(), payload.getSummary(), NetworkEvents::handleSettingForward$lambda$2, NetworkEvents::handleSettingForward$lambda$3);
    }

    public final void registerDataSync(@NotNull OnDatapackSyncEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ServerPlayer serverPlayer = event.getPlayer();
        if (serverPlayer == null) {
            List list = event.getRelevantPlayers().toList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
            SyncedConfigRegistry.INSTANCE.onEndDataReload$fzzy_config(list, NetworkEvents::registerDataSync$lambda$4, NetworkEvents::registerDataSync$lambda$5);
            ConfigApiImpl.INSTANCE.invalidateLookup$fzzy_config();
        } else {
            MinecraftServer minecraftServer = serverPlayer.level().getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            SyncedConfigRegistry.INSTANCE.onJoin$fzzy_config(serverPlayer, minecraftServer, NetworkEvents::registerDataSync$lambda$6, NetworkEvents::registerDataSync$lambda$7);
        }
    }

    public final void registerConfigurations(@NotNull RegisterConfigurationTasksEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.register(new ConfigurationTask(event){
            private final ConfigurationTask.Type key;
            final /* synthetic */ RegisterConfigurationTasksEvent $event;
            {
                this.$event = $event;
                this.key = new ConfigurationTask.Type(ConfigSyncS2CCustomPayload.Companion.getType().id());
            }

            public void start(Consumer<Packet<?>> sender2) {
                Intrinsics.checkNotNullParameter(sender2, (String)"sender");
                SyncedConfigRegistry.INSTANCE.onConfigure$fzzy_config(arg_0 -> registerConfigurations.1.sendPacket$lambda$0(this.$event, arg_0), arg_0 -> registerConfigurations.1.sendPacket$lambda$1(sender2, arg_0));
                this.$event.getListener().finishCurrentTask(this.key);
            }

            public ConfigurationTask.Type type() {
                return this.key;
            }

            private static final boolean sendPacket$lambda$0(RegisterConfigurationTasksEvent $event, CustomPacketPayload.Type type) {
                Intrinsics.checkNotNullParameter((Object)type, (String)"<unused var>");
                return NetworkRegistry.hasChannel((ICommonPacketListener)((ICommonPacketListener)$event.getListener()), (ResourceLocation)ConfigSyncS2CCustomPayload.Companion.getType().id());
            }

            private static final void sendPacket$lambda$1(Consumer $sender, CustomPacketPayload payload) {
                Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
                $sender.accept(payload.toVanillaClientbound());
            }
        });
    }

    public final void registerPayloads(@NotNull RegisterPayloadHandlersEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PayloadRegistrar registrar = event.registrar("fzzy_config").optional();
        registrar.configurationToClient(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec(), NetworkEventsClient.INSTANCE::handleConfigurationConfigSync);
        registrar.playToClient(ConfigSyncS2CCustomPayload.Companion.getType(), ConfigSyncS2CCustomPayload.Companion.getCodec(), NetworkEventsClient.INSTANCE::handleReloadConfigSync);
        registrar.playToClient(ConfigPermissionsS2CCustomPayload.Companion.getType(), ConfigPermissionsS2CCustomPayload.Companion.getCodec(), NetworkEventsClient.INSTANCE::handlePermsUpdate);
        registrar.playToClient(ConfigUpdateS2CCustomPayload.Companion.getType(), ConfigUpdateS2CCustomPayload.Companion.getCodec(), NetworkEventsClient.INSTANCE::handleUpdate);
        registrar.playToServer(ConfigUpdateC2SCustomPayload.Companion.getType(), ConfigUpdateC2SCustomPayload.Companion.getCodec(), this::handleUpdate);
        registrar.playBidirectional(SettingForwardCustomPayload.Companion.getType(), SettingForwardCustomPayload.Companion.getCodec(), this::handleSettingForwardBidirectional, this::handleSettingForwardBidirectional);
        registrar.playToClient(DynamicIdsS2CCustomPayload.Companion.getType(), DynamicIdsS2CCustomPayload.Companion.getCodec(), NetworkEventsClient.INSTANCE::receiveDynamicIds);
    }

    public final void serverStarted(@NotNull ServerStartedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getServer().isDedicatedServer()) {
            MinecraftServer minecraftServer = event.getServer();
            Intrinsics.checkNotNullExpressionValue((Object)minecraftServer, (String)"getServer(...)");
            SyncedConfigRegistry.INSTANCE.start$fzzy_config(minecraftServer);
        }
    }

    public final void gameStopping(@NotNull GameShuttingDownEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ThreadingUtils.INSTANCE.stop();
    }

    private static final boolean handleUpdate$lambda$0(ServerPlayer player, CustomPacketPayload.Type id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void handleUpdate$lambda$1(ServerPlayer player, CustomPacketPayload pl) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        INSTANCE.send(player, pl);
    }

    private static final boolean handleSettingForward$lambda$2(ServerPlayer player, CustomPacketPayload.Type id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void handleSettingForward$lambda$3(ServerPlayer player, CustomPacketPayload pl) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pl, (String)"pl");
        INSTANCE.send(player, pl);
    }

    private static final boolean registerDataSync$lambda$4(ServerPlayer player, CustomPacketPayload.Type id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void registerDataSync$lambda$5(ServerPlayer player, CustomPacketPayload payload) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        INSTANCE.send(player, payload);
    }

    private static final boolean registerDataSync$lambda$6(ServerPlayer player, CustomPacketPayload.Type id) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return INSTANCE.canSend(player, id);
    }

    private static final void registerDataSync$lambda$7(ServerPlayer player, CustomPacketPayload payload) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        INSTANCE.send(player, payload);
    }
}

