/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.screen;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.screen.LastSelectable;
import me.fzzyhmstrs.fzzy_config.screen.PopupController;
import me.fzzyhmstrs.fzzy_config.screen.widget.PopupWidget;
import me.fzzyhmstrs.fzzy_config.util.TriState;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u00012\u00020\u0002J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J%\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J/\u0010\u0019\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ'\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00102\u0006\u0010 \u001a\u00020#H\u0016\u00a2\u0006\u0004\b$\u0010%R\u0016\u0010)\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006*\u00c0\u0006\u0003"}, d2={"Lme/fzzyhmstrs/fzzy_config/screen/PopupParentElement;", "Lnet/minecraft/client/gui/components/events/ContainerEventHandler;", "Lme/fzzyhmstrs/fzzy_config/screen/PopupController;", "", "pushLast", "()V", "popLast", "", "mouseX", "mouseY", "Ljava/util/Optional;", "Lnet/minecraft/client/gui/components/events/GuiEventListener;", "hoveredElement", "(DD)Ljava/util/Optional;", "Lnet/minecraft/client/input/MouseButtonEvent;", "click", "", "doubled", "mouseClicked", "(Lnet/minecraft/client/input/MouseButtonEvent;Z)Z", "mouseClick", "mouseReleased", "(Lnet/minecraft/client/input/MouseButtonEvent;)Z", "horizontalAmount", "verticalAmount", "mouseScrolled", "(DDDD)Z", "offsetX", "offsetY", "mouseDragged", "(Lnet/minecraft/client/input/MouseButtonEvent;DD)Z", "Lnet/minecraft/client/input/KeyEvent;", "input", "keyReleased", "(Lnet/minecraft/client/input/KeyEvent;)Z", "Lnet/minecraft/client/input/CharacterEvent;", "charTyped", "(Lnet/minecraft/client/input/CharacterEvent;)Z", "Lme/fzzyhmstrs/fzzy_config/screen/LastSelectable;", "getChild", "()Lme/fzzyhmstrs/fzzy_config/screen/LastSelectable;", "child", "fzzy_config"})
public interface PopupParentElement
extends ContainerEventHandler,
PopupController {
    @Override
    @Nullable
    default public LastSelectable getChild() {
        GuiEventListener guiEventListener = this.getFocused();
        return guiEventListener instanceof LastSelectable ? (LastSelectable)guiEventListener : null;
    }

    @Override
    default public void pushLast() {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener != null) {
            guiEventListener.setFocused(false);
        }
        this.setLastSelected(this.getFocused());
    }

    @Override
    default public void popLast() {
        GuiEventListener guiEventListener = this.getLastSelected();
        if (guiEventListener != null) {
            guiEventListener.setFocused(true);
        }
        this.setFocused(this.getLastSelected());
    }

    @NotNull
    default public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        if (this.getPopupWidgets().isEmpty()) {
            Optional optional = super.getChildAt(mouseX, mouseY);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"hoveredElement(...)");
            return optional;
        }
        Optional<GuiEventListener> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        return optional;
    }

    default public boolean mouseClicked(@NotNull MouseButtonEvent click, boolean doubled) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        PopupWidget popupWidget = this.activeWidget();
        if (popupWidget == null) {
            return this.mouseClick(click, doubled);
        }
        PopupWidget popupWidget2 = popupWidget;
        if (popupWidget2.mouseClicked(click, doubled) || popupWidget2.isMouseOver(click.x(), click.y())) {
            return true;
        }
        if (popupWidget2.closesOnMissedClick() != TriState.FALSE) {
            this.setPopupInternal(null, click.x(), click.y(), false);
            if (popupWidget2.closesOnMissedClick().getAsBoolean()) {
                return this.mouseClick(click, doubled);
            }
        }
        return false;
    }

    private boolean mouseClick(MouseButtonEvent click, boolean doubled) {
        for (GuiEventListener element : this.children()) {
            if (!element.mouseClicked(click, doubled)) continue;
            this.setFocused(element);
            if (click.button() == 0) {
                this.setDragging(true);
            }
            return true;
        }
        return false;
    }

    default public boolean mouseReleased(@NotNull MouseButtonEvent click) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        if (this.getJustClosedWidget()) {
            this.setJustClosedWidget(false);
            return false;
        }
        PopupWidget popupWidget = this.activeWidget();
        if (popupWidget == null) {
            return super.mouseReleased(click);
        }
        PopupWidget popupWidget2 = popupWidget;
        if (popupWidget2.isMouseOver(click.x(), click.y()) || popupWidget2.isDragging()) {
            return popupWidget2.mouseReleased(click);
        }
        return false;
    }

    default public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        PopupWidget popupWidget = this.activeWidget();
        if (popupWidget == null) {
            return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }
        PopupWidget popupWidget2 = popupWidget;
        return popupWidget2.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    default public boolean mouseDragged(@NotNull MouseButtonEvent click, double offsetX, double offsetY) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        PopupWidget popupWidget = this.activeWidget();
        if (popupWidget == null) {
            return super.mouseDragged(click, offsetX, offsetY);
        }
        PopupWidget popupWidget2 = popupWidget;
        return popupWidget2.mouseDragged(click, offsetX, offsetY);
    }

    default public boolean keyReleased(@NotNull KeyEvent input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PopupWidget popupWidget = this.activeWidget();
        return popupWidget != null ? popupWidget.keyReleased(input) : super.keyReleased(input);
    }

    default public boolean charTyped(@NotNull CharacterEvent input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PopupWidget popupWidget = this.activeWidget();
        return popupWidget != null ? popupWidget.charTyped(input) : super.charTyped(input);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static LastSelectable getChild(@NotNull PopupParentElement $this) {
            return $this.getChild();
        }

        @Deprecated
        public static void pushLast(@NotNull PopupParentElement $this) {
            $this.pushLast();
        }

        @Deprecated
        public static void popLast(@NotNull PopupParentElement $this) {
            $this.popLast();
        }

        @Deprecated
        @NotNull
        public static Optional<GuiEventListener> hoveredElement(@NotNull PopupParentElement $this, double mouseX, double mouseY) {
            return $this.getChildAt(mouseX, mouseY);
        }

        @Deprecated
        public static boolean mouseClicked(@NotNull PopupParentElement $this, @NotNull MouseButtonEvent click, boolean doubled) {
            Intrinsics.checkNotNullParameter((Object)click, (String)"click");
            return $this.mouseClicked(click, doubled);
        }

        @Deprecated
        public static boolean mouseReleased(@NotNull PopupParentElement $this, @NotNull MouseButtonEvent click) {
            Intrinsics.checkNotNullParameter((Object)click, (String)"click");
            return $this.mouseReleased(click);
        }

        @Deprecated
        public static boolean mouseScrolled(@NotNull PopupParentElement $this, double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            return $this.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }

        @Deprecated
        public static boolean mouseDragged(@NotNull PopupParentElement $this, @NotNull MouseButtonEvent click, double offsetX, double offsetY) {
            Intrinsics.checkNotNullParameter((Object)click, (String)"click");
            return $this.mouseDragged(click, offsetX, offsetY);
        }

        @Deprecated
        public static boolean keyReleased(@NotNull PopupParentElement $this, @NotNull KeyEvent input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return $this.keyReleased(input);
        }

        @Deprecated
        public static boolean charTyped(@NotNull PopupParentElement $this, @NotNull CharacterEvent input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return $this.charTyped(input);
        }

        @Deprecated
        @Nullable
        public static PopupWidget activeWidget(@NotNull PopupParentElement $this) {
            return $this.activeWidget();
        }

        @Deprecated
        public static void setPopup(@NotNull PopupParentElement $this, @Nullable PopupWidget widget, @Nullable Double mouseX, @Nullable Double mouseY) {
            $this.setPopup(widget, mouseX, mouseY);
        }

        @Deprecated
        public static void setPopupImmediate(@NotNull PopupParentElement $this, @Nullable PopupWidget widget, @Nullable Double mouseX, @Nullable Double mouseY) {
            $this.setPopupImmediate(widget, mouseX, mouseY);
        }

        @Deprecated
        @ApiStatus.Internal
        public static void setPopupInternal(@NotNull PopupParentElement $this, @Nullable PopupWidget widget, @Nullable Double mouseX, @Nullable Double mouseY, boolean setJustClosed) {
            $this.setPopupInternal(widget, mouseX, mouseY, setJustClosed);
        }

        @Deprecated
        public static void preRender(@NotNull PopupParentElement $this, @NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            $this.preRender(context, mouseX, mouseY, delta);
        }

        @Deprecated
        public static void postRender(@NotNull PopupParentElement $this, @NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            $this.postRender(context, mouseX, mouseY, delta);
        }

        @Deprecated
        public static void blurBackground(@NotNull PopupParentElement $this, @NotNull GuiGraphics context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            $this.blurBackground(context);
        }

        @Deprecated
        public static void resetHover(@NotNull PopupParentElement $this, double mouseX, double mouseY) {
            $this.resetHover(mouseX, mouseY);
        }
    }
}

