/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.screen.widget.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010 \u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\"R\u001c\u0010%\u001a\n $*\u0004\u0018\u00010#0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0016\u0010'\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/fzzyhmstrs/fzzy_config/screen/widget/internal/NavigableTextFieldWidget;", "Lnet/minecraft/client/gui/components/EditBox;", "Lnet/minecraft/client/gui/Font;", "textRenderer", "", "width", "height", "Lnet/minecraft/network/chat/Component;", "text", "<init>", "(Lnet/minecraft/client/gui/Font;IILnet/minecraft/network/chat/Component;)V", "Lnet/minecraft/client/input/KeyEvent;", "input", "", "keyPressed", "(Lnet/minecraft/client/input/KeyEvent;)Z", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "Lnet/minecraft/client/input/MouseButtonEvent;", "click", "doubled", "onClick", "(Lnet/minecraft/client/input/MouseButtonEvent;Z)V", "cursor", "shiftKeyPressed", "setCursor", "(IZ)V", "Lnet/minecraft/client/gui/Font;", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "searchText", "Lnet/minecraft/network/chat/MutableComponent;", "clicked", "Z", "fzzy_config"})
public final class NavigableTextFieldWidget
extends EditBox {
    @NotNull
    private final Font textRenderer;
    private final MutableComponent searchText;
    private boolean clicked;

    public NavigableTextFieldWidget(@NotNull Font textRenderer, int width, int height, @NotNull Component text) {
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(textRenderer, width, height, text);
        this.textRenderer = textRenderer;
        ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC};
        this.searchText = FcText.INSTANCE.translate("fc.config.search", new Object[0]).withStyle(chatFormattingArray);
    }

    public boolean keyPressed(@NotNull KeyEvent input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!this.isActive() || !this.isFocused()) {
            return false;
        }
        if (input.isLeft()) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return false;
            }
        }
        if (input.isRight()) {
            String string = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                return false;
            }
        }
        return super.keyPressed(input);
    }

    public void renderWidget(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.renderWidget(context, mouseX, mouseY, delta);
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() == 0 && !this.isFocused()) {
            int k = this.isBordered() ? this.getX() + 4 : this.getX();
            int l = this.isBordered() ? this.getY() + (this.height - 8) / 2 : this.getY();
            context.drawString(this.textRenderer, (Component)this.searchText, k, l, -1);
        }
    }

    public void onClick(@NotNull MouseButtonEvent click, boolean doubled) {
        Intrinsics.checkNotNullParameter((Object)click, (String)"click");
        this.clicked = true;
        super.onClick(click, doubled);
        this.clicked = false;
    }

    public void moveCursorTo(int cursor, boolean shiftKeyPressed) {
        if (this.clicked) {
            this.setCursorPosition(cursor);
            if (!shiftKeyPressed) {
                this.setHighlightPos(this.getCursorPosition());
            }
        } else {
            super.moveCursorTo(cursor, shiftKeyPressed);
        }
    }
}

